/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.core;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.enhydra.jdbc.util.JdbcUtil;

public abstract class CoreStatement
extends JdbcUtil
implements Statement {
    protected Statement statement;

    public void addBatch(String string) throws SQLException {
        try {
            this.statement.addBatch(string);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void cancel() throws SQLException {
        try {
            this.statement.cancel();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.statement.clearBatch();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.statement.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void close() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
        }
    }

    public boolean execute(String string) throws SQLException {
        try {
            return this.statement.execute(string);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return false;
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            return this.statement.executeBatch();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        try {
            return this.statement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public int executeUpdate(String string) throws SQLException {
        try {
            return this.statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return 0;
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            return this.statement.getConnection();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            return this.statement.getFetchDirection();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return 0;
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            return this.statement.getFetchSize();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return 0;
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.statement.getGeneratedKeys();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            return this.statement.getMaxFieldSize();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return 0;
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            return this.statement.getMaxRows();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return 0;
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            return this.statement.getMoreResults();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return false;
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            return this.statement.getQueryTimeout();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return 0;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            return this.statement.getResultSet();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.statement.getResultSetConcurrency();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return 0;
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            return this.statement.getResultSetType();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return 0;
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            return this.statement.getUpdateCount();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return 0;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.statement.getWarnings();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public void setCursorName(String string) throws SQLException {
        try {
            this.statement.setCursorName(string);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            this.statement.setEscapeProcessing(bl);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        try {
            this.statement.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void setFetchSize(int n) throws SQLException {
        try {
            this.statement.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void setMaxFieldSize(int n) throws SQLException {
        try {
            this.statement.setMaxFieldSize(n);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void setMaxRows(int n) throws SQLException {
        try {
            this.statement.setMaxRows(n);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        try {
            this.statement.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public boolean execute(String string, int n) throws SQLException {
        try {
            return this.statement.execute(string, n);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return false;
        }
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            return this.statement.execute(string, nArray);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return false;
        }
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            return this.statement.execute(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return false;
        }
    }

    public int executeUpdate(String string, int n) throws SQLException {
        try {
            return this.statement.executeUpdate(string, n);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return 0;
        }
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            return this.statement.executeUpdate(string, nArray);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return 0;
        }
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            return this.statement.executeUpdate(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return 0;
        }
    }

    public boolean getMoreResults(int n) throws SQLException {
        try {
            return this.statement.getMoreResults(n);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return false;
        }
    }

    public int getResultSetHoldability() throws SQLException {
        try {
            return this.statement.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return 0;
        }
    }

    public abstract void catchInvoke(SQLException var1) throws SQLException;
}

