/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.core;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.enhydra.jdbc.core.JdbcThreadFactory;
import org.enhydra.jdbc.util.JdbcUtil;
import org.enhydra.jdbc.util.Logger;

public class CoreDataSource
extends JdbcUtil
implements Referenceable,
ObjectFactory,
Serializable {
    private int loginTimeout = 60;
    public transient PrintWriter logWriter = null;
    public String user = null;
    public String password = null;
    private String description = null;
    private boolean debug = false;
    private boolean verbose = false;
    private JdbcThreadFactory threadFactory = null;

    public String getDescription() {
        return this.description;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }

    public JdbcThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setThreadFactory(JdbcThreadFactory jdbcThreadFactory) {
        this.threadFactory = jdbcThreadFactory;
    }

    public PrintWriter getLogWriter() {
        return this.log;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.log = (Logger)printWriter;
    }

    public void shutdown(boolean bl) {
    }

    public void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), this.getClass().getName(), null);
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.getPassword()));
        reference.add(new StringRefAddr("description", this.getDescription()));
        reference.add(new StringRefAddr("loginTimeout", Integer.toString(this.getLoginTimeout())));
        this.log.debug("CoreDataSource:getReference object returned");
        return reference;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Reference reference = (Reference)object;
        this.setUser((String)reference.get("user").getContent());
        this.setPassword((String)reference.get("password").getContent());
        this.setDescription((String)reference.get("description").getContent());
        this.setLoginTimeout(Integer.parseInt((String)reference.get("loginTimeout").getContent()));
        this.log.debug("CoreDataSource:getObjectInstance instance created");
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CoreDataSource :\n");
        stringBuffer.append("     debug =<" + this.debug + ">\n");
        stringBuffer.append("     description =<" + this.description + ">\n");
        stringBuffer.append("     login time out =<" + this.loginTimeout + ">\n");
        stringBuffer.append("     user =<" + this.user + ">\n");
        stringBuffer.append("     verbose =<" + this.verbose + ">\n");
        return stringBuffer.toString();
    }
}

