/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.core;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.enhydra.jdbc.util.JdbcUtil;

public abstract class CoreConnection
extends JdbcUtil
implements Connection {
    public Connection con;

    public CoreConnection(Connection connection) {
        this.con = connection;
    }

    public CoreConnection() {
    }

    public void clearWarnings() throws SQLException {
        this.preInvoke();
        try {
            this.con.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void close() throws SQLException {
        this.preInvoke();
        try {
            this.con.close();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void commit() throws SQLException {
        this.preInvoke();
        try {
            this.con.commit();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public Statement createStatement() throws SQLException {
        this.preInvoke();
        try {
            return this.con.createStatement();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.preInvoke();
        try {
            return this.con.createStatement(n, n2);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return false;
        }
    }

    public String getCatalog() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getCatalog();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getMetaData();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return 0;
        }
    }

    public Map getTypeMap() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getTypeMap();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getWarnings();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public boolean isReadOnly() throws SQLException {
        this.preInvoke();
        try {
            return this.con.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return false;
        }
    }

    public String nativeSQL(String string) throws SQLException {
        this.preInvoke();
        try {
            return this.con.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareCall(string);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareStatement(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public void rollback() throws SQLException {
        this.preInvoke();
        try {
            this.con.rollback();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.log.debug("CoreConnection:Setautocommit autoCommit was = " + this.con.getAutoCommit());
        this.log.debug("CoreConnection:Setautocommit = " + bl);
        this.preInvoke();
        try {
            this.con.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void setCatalog(String string) throws SQLException {
        this.preInvoke();
        try {
            this.con.setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.preInvoke();
        try {
            this.con.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.preInvoke();
        try {
            this.con.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        this.preInvoke();
        try {
            this.con.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.preInvoke();
        try {
            return this.con.createStatement(n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public int getHoldability() throws SQLException {
        this.preInvoke();
        try {
            return this.con.getHoldability();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return 0;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareCall(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareStatement(string, n);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.preInvoke();
        try {
            return this.prepareStatement(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareStatement(string, nArray);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareStatement(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.preInvoke();
        try {
            this.con.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.preInvoke();
        try {
            this.con.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public void setHoldability(int n) throws SQLException {
        this.preInvoke();
        try {
            this.con.setHoldability(n);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        this.preInvoke();
        try {
            return this.con.setSavepoint();
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        this.preInvoke();
        try {
            return this.con.setSavepoint(string);
        }
        catch (SQLException sQLException) {
            this.catchInvoke(sQLException);
            return null;
        }
    }

    public abstract void preInvoke() throws SQLException;

    public abstract void catchInvoke(SQLException var1) throws SQLException;
}

