/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.SimpleTransformErrorListener;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.xslt.TransformerUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XsltView
extends AbstractUrlBasedView {
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private String sourceKey;
    private URIResolver uriResolver;
    private ErrorListener errorListener = new SimpleTransformErrorListener(this.logger);
    private boolean indent = true;
    private Properties outputProperties;
    private boolean cacheTemplates = true;
    private Templates cachedTemplates;
    static /* synthetic */ Class class$javax$xml$transform$Source;
    static /* synthetic */ Class class$org$w3c$dom$Document;
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$org$springframework$core$io$Resource;

    public void setSourceKey(String string) {
        this.sourceKey = string;
    }

    public void setUriResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener != null ? errorListener : new SimpleTransformErrorListener(this.logger);
    }

    public void setIndent(boolean bl) {
        this.indent = bl;
    }

    public void setOutputProperties(Properties properties) {
        this.outputProperties = properties;
    }

    public void setCacheTemplates(boolean bl) {
        this.cacheTemplates = bl;
    }

    protected void initApplicationContext() throws BeansException {
        this.transformerFactory.setErrorListener(this.errorListener);
        if (this.uriResolver != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using custom URIResolver '" + this.uriResolver + "' in XSLT view with URL '" + this.getUrl() + "'"));
            }
            this.transformerFactory.setURIResolver(this.uriResolver);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("URL in view is '" + this.getUrl() + "'"));
        }
        if (this.cacheTemplates) {
            this.cachedTemplates = this.loadTemplates();
        }
    }

    protected final TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderMergedOutputModel(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Templates templates = this.cachedTemplates;
        if (templates == null) {
            templates = this.loadTemplates();
        }
        Transformer transformer = this.createTransformer(templates);
        this.configureTransformer(map, httpServletResponse, transformer);
        this.configureResponse(map, httpServletResponse, transformer);
        Source source = null;
        try {
            source = this.locateSource(map);
            if (source == null) {
                throw new IllegalArgumentException("Unable to locate Source object in model: " + map);
            }
            transformer.transform(source, this.createResult(httpServletResponse));
        }
        finally {
            this.closeSourceIfNecessary(source);
        }
    }

    protected Result createResult(HttpServletResponse httpServletResponse) throws Exception {
        return new StreamResult((OutputStream)httpServletResponse.getOutputStream());
    }

    protected Source locateSource(Map map) throws Exception {
        if (this.sourceKey != null) {
            return this.convertSource(map.get(this.sourceKey));
        }
        Object object = CollectionUtils.findValueOfType(map.values(), (Class[])this.getSourceTypes());
        return object != null ? this.convertSource(object) : null;
    }

    protected Class[] getSourceTypes() {
        return new Class[]{class$javax$xml$transform$Source == null ? (class$javax$xml$transform$Source = XsltView.class$("javax.xml.transform.Source")) : class$javax$xml$transform$Source, class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = XsltView.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document, class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = XsltView.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node, class$java$io$Reader == null ? (class$java$io$Reader = XsltView.class$("java.io.Reader")) : class$java$io$Reader, class$java$io$InputStream == null ? (class$java$io$InputStream = XsltView.class$("java.io.InputStream")) : class$java$io$InputStream, class$org$springframework$core$io$Resource == null ? (class$org$springframework$core$io$Resource = XsltView.class$("org.springframework.core.io.Resource")) : class$org$springframework$core$io$Resource};
    }

    protected Source convertSource(Object object) throws Exception {
        if (object instanceof Source) {
            return (Source)object;
        }
        if (object instanceof Document) {
            return new DOMSource(((Document)object).getDocumentElement());
        }
        if (object instanceof Node) {
            return new DOMSource((Node)object);
        }
        if (object instanceof Reader) {
            return new StreamSource((Reader)object);
        }
        if (object instanceof InputStream) {
            return new StreamSource((InputStream)object);
        }
        if (object instanceof Resource) {
            return new StreamSource(((Resource)object).getInputStream());
        }
        throw new IllegalArgumentException("Value '" + object + "' cannot be converted to XSLT Source");
    }

    protected void configureTransformer(Map map, HttpServletResponse httpServletResponse, Transformer transformer) {
        this.copyModelParameters(map, transformer);
        this.copyOutputProperties(transformer);
        this.configureIndentation(transformer);
    }

    protected final void configureIndentation(Transformer transformer) {
        if (this.indent) {
            TransformerUtils.enableIndenting(transformer);
        } else {
            TransformerUtils.disableIndenting(transformer);
        }
    }

    protected final void copyOutputProperties(Transformer transformer) {
        if (this.outputProperties != null) {
            Enumeration<?> enumeration = this.outputProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                transformer.setOutputProperty(string, this.outputProperties.getProperty(string));
            }
        }
    }

    protected final void copyModelParameters(Map map, Transformer transformer) {
        this.copyMapEntriesToTransformerParameters(map, transformer);
    }

    protected void configureResponse(Map map, HttpServletResponse httpServletResponse, Transformer transformer) {
        String string = this.getContentType();
        String string2 = transformer.getOutputProperty("media-type");
        String string3 = transformer.getOutputProperty("encoding");
        if (StringUtils.hasText((String)string2)) {
            string = string2;
        }
        if (StringUtils.hasText((String)string3) && string != null && string.toLowerCase().indexOf(";charset=") == -1) {
            string = string + ";charset=" + string3;
        }
        httpServletResponse.setContentType(string);
    }

    private Templates loadTemplates() throws ApplicationContextException {
        Source source = this.getStylesheetSource();
        try {
            Templates templates = this.transformerFactory.newTemplates(source);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loading templates '" + templates + "'"));
            }
            Templates templates2 = templates;
            return templates2;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new ApplicationContextException("Can't load stylesheet from '" + this.getUrl() + "'", (Throwable)transformerConfigurationException);
        }
        finally {
            this.closeSourceIfNecessary(source);
        }
    }

    protected Transformer createTransformer(Templates templates) throws TransformerConfigurationException {
        Transformer transformer = templates.newTransformer();
        if (this.uriResolver != null) {
            transformer.setURIResolver(this.uriResolver);
        }
        return transformer;
    }

    protected Source getStylesheetSource() {
        String string = this.getUrl();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loading XSLT stylesheet from '" + string + "'"));
        }
        try {
            Resource resource = this.getApplicationContext().getResource(string);
            String string2 = string.substring(0, string.lastIndexOf(47) + 1);
            return new StreamSource(resource.getInputStream(), string2);
        }
        catch (IOException iOException) {
            throw new ApplicationContextException("Can't load XSLT stylesheet from '" + string + "'", (Throwable)iOException);
        }
    }

    private void copyMapEntriesToTransformerParameters(Map map, Transformer transformer) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            transformer.setParameter(ObjectUtils.nullSafeToString(entry.getKey()), entry.getValue());
        }
    }

    private void closeSourceIfNecessary(Source source) {
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            if (streamSource.getReader() != null) {
                try {
                    streamSource.getReader().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (streamSource.getInputStream() != null) {
                try {
                    streamSource.getInputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

