/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.xslt;

import javax.xml.transform.Transformer;
import org.springframework.util.Assert;

public abstract class TransformerUtils {
    public static final int DEFAULT_INDENT_AMOUNT = 2;

    public static void enableIndenting(Transformer transformer) {
        TransformerUtils.enableIndenting(transformer, 2);
    }

    public static void enableIndenting(Transformer transformer, int n) {
        Assert.notNull((Object)transformer);
        Assert.isTrue((n > -1 ? 1 : 0) != 0, (String)("The indent amount cannot be less than zero : got " + n));
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(n));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void disableIndenting(Transformer transformer) {
        Assert.notNull((Object)transformer);
        transformer.setOutputProperty("indent", "no");
    }
}

