/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.xslt;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.Resource;
import org.springframework.util.xml.SimpleTransformErrorListener;
import org.springframework.web.servlet.view.AbstractView;
import org.springframework.web.servlet.view.xslt.TransformerUtils;
import org.springframework.web.util.NestedServletException;
import org.w3c.dom.Node;

public abstract class AbstractXsltView
extends AbstractView {
    public static final String XML_CONTENT_TYPE = "text/xml;charset=ISO-8859-1";
    public static final String DEFAULT_ROOT = "DocRoot";
    private boolean customContentTypeSet = false;
    private Resource stylesheetLocation;
    private String root = "DocRoot";
    private boolean useSingleModelNameAsRoot = true;
    private URIResolver uriResolver;
    private ErrorListener errorListener = new SimpleTransformErrorListener(this.logger);
    private boolean indent = true;
    private Properties outputProperties;
    private boolean cache = true;
    private TransformerFactory transformerFactory;
    private volatile Templates cachedTemplates;

    protected AbstractXsltView() {
        super.setContentType(XML_CONTENT_TYPE);
    }

    public void setContentType(String string) {
        super.setContentType(string);
        this.customContentTypeSet = true;
    }

    public void setStylesheetLocation(Resource resource) {
        this.stylesheetLocation = resource;
        this.resetCachedTemplates();
    }

    protected Resource getStylesheetLocation() {
        return this.stylesheetLocation;
    }

    public void setRoot(String string) {
        this.root = string;
    }

    public void setUseSingleModelNameAsRoot(boolean bl) {
        this.useSingleModelNameAsRoot = bl;
    }

    public void setUriResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public void setIndent(boolean bl) {
        this.indent = bl;
    }

    public void setOutputProperties(Properties properties) {
        this.outputProperties = properties;
    }

    public void setCache(boolean bl) {
        this.cache = bl;
    }

    public final void resetCachedTemplates() {
        this.cachedTemplates = null;
    }

    protected final void initApplicationContext() throws ApplicationContextException {
        this.transformerFactory = TransformerFactory.newInstance();
        this.transformerFactory.setErrorListener(this.errorListener);
        if (this.uriResolver != null) {
            this.transformerFactory.setURIResolver(this.uriResolver);
        }
        if (this.getStylesheetLocation() != null && !this.customContentTypeSet) {
            super.setContentType("text/html;charset=ISO-8859-1");
        }
        try {
            this.getTemplates();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new ApplicationContextException("Cannot load stylesheet for XSLT view '" + this.getBeanName() + "'", (Throwable)transformerConfigurationException);
        }
    }

    protected final TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    protected final void renderMergedOutputModel(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        httpServletResponse.setContentType(this.getContentType());
        Source source = null;
        String string = null;
        Object var6_6 = null;
        if (this.useSingleModelNameAsRoot && map.size() == 1) {
            string = (String)map.keySet().iterator().next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Single model object received, key [" + string + "] will be used as root tag"));
            }
            var6_6 = map.get(string);
        }
        if (var6_6 instanceof Node || var6_6 instanceof Source) {
            this.logger.debug((Object)"No need to domify: was passed an XML Node or Source");
            source = var6_6 instanceof Node ? new DOMSource(var6_6) : (Source)var6_6;
        } else {
            source = this.createXsltSource(map, string != null ? string : this.root, httpServletRequest, httpServletResponse);
        }
        this.doTransform(map, source, httpServletRequest, httpServletResponse);
    }

    protected Source createXsltSource(Map map, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        return null;
    }

    protected void doTransform(Map map, Source source, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Map map2 = this.getParameters(map, httpServletRequest);
        StreamResult streamResult = this.useWriter() ? new StreamResult(httpServletResponse.getWriter()) : new StreamResult(new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream()));
        String string = httpServletResponse.getCharacterEncoding();
        this.doTransform(source, map2, streamResult, string);
    }

    protected Map getParameters(Map map, HttpServletRequest httpServletRequest) {
        return this.getParameters(httpServletRequest);
    }

    protected Map getParameters(HttpServletRequest httpServletRequest) {
        return this.getParameters();
    }

    protected Map getParameters() {
        return null;
    }

    protected boolean useWriter() {
        return false;
    }

    protected void doTransform(Source source, Map map, Result result, String string) throws Exception {
        try {
            Transformer transformer = this.buildTransformer(map);
            if (this.uriResolver != null) {
                transformer.setURIResolver(this.uriResolver);
            }
            transformer.setOutputProperty("encoding", string);
            if (this.indent) {
                TransformerUtils.enableIndenting(transformer);
            }
            if (this.outputProperties != null) {
                Enumeration<?> enumeration = this.outputProperties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    transformer.setOutputProperty(string2, this.outputProperties.getProperty(string2));
                }
            }
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new NestedServletException("Couldn't create XSLT transformer in XSLT view with name [" + this.getBeanName() + "]", (Throwable)transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new NestedServletException("Couldn't perform transform in XSLT view with name [" + this.getBeanName() + "]", (Throwable)transformerException);
        }
    }

    protected Transformer buildTransformer(Map map) throws TransformerConfigurationException {
        Templates templates = this.getTemplates();
        Transformer transformer = templates != null ? templates.newTransformer() : this.getTransformerFactory().newTransformer();
        this.applyTransformerParameters(map, transformer);
        return transformer;
    }

    protected Templates getTemplates() throws TransformerConfigurationException {
        if (this.cachedTemplates != null) {
            return this.cachedTemplates;
        }
        Resource resource = this.getStylesheetLocation();
        if (resource != null) {
            Templates templates = this.getTransformerFactory().newTemplates(this.getStylesheetSource(resource));
            if (this.cache) {
                this.cachedTemplates = templates;
            }
            return templates;
        }
        return null;
    }

    protected void applyTransformerParameters(Map map, Transformer transformer) {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                transformer.setParameter(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    protected Source getStylesheetSource(Resource resource) throws ApplicationContextException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loading XSLT stylesheet from " + resource));
        }
        try {
            URL uRL = resource.getURL();
            String string = uRL.toString();
            String string2 = string.substring(0, string.lastIndexOf(47) + 1);
            return new StreamSource(uRL.openStream(), string2);
        }
        catch (IOException iOException) {
            throw new ApplicationContextException("Can't load XSLT stylesheet from " + resource, (Throwable)iOException);
        }
    }
}

