/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.velocity;

import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.app.tools.VelocityFormatter;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractTemplateView;
import org.springframework.web.servlet.view.velocity.VelocityConfig;
import org.springframework.web.util.NestedServletException;

public class VelocityView
extends AbstractTemplateView {
    private Map toolAttributes;
    private String velocityFormatterAttribute;
    private String dateToolAttribute;
    private String numberToolAttribute;
    private String encoding;
    private boolean cacheTemplate = false;
    private VelocityEngine velocityEngine;
    private Template template;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$velocity$VelocityConfig;

    public void setToolAttributes(Properties properties) {
        this.toolAttributes = new HashMap(properties.size());
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            Class clazz = null;
            try {
                clazz = ClassUtils.forName((String)string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Invalid definition for tool '" + string + "' - tool class not found: " + classNotFoundException.getMessage());
            }
            this.toolAttributes.put(string, clazz);
        }
    }

    public void setVelocityFormatterAttribute(String string) {
        this.velocityFormatterAttribute = string;
    }

    public void setDateToolAttribute(String string) {
        this.dateToolAttribute = string;
    }

    public void setNumberToolAttribute(String string) {
        this.numberToolAttribute = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    public void setCacheTemplate(boolean bl) {
        this.cacheTemplate = bl;
    }

    protected boolean isCacheTemplate() {
        return this.cacheTemplate;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    protected VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        if (this.getVelocityEngine() == null) {
            this.setVelocityEngine(this.autodetectVelocityEngine());
        }
        this.checkTemplate();
    }

    protected VelocityEngine autodetectVelocityEngine() throws BeansException {
        try {
            VelocityConfig velocityConfig = (VelocityConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), (Class)(class$org$springframework$web$servlet$view$velocity$VelocityConfig == null ? (class$org$springframework$web$servlet$view$velocity$VelocityConfig = VelocityView.class$("org.springframework.web.servlet.view.velocity.VelocityConfig")) : class$org$springframework$web$servlet$view$velocity$VelocityConfig), (boolean)true, (boolean)false);
            return velocityConfig.getVelocityEngine();
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            throw new ApplicationContextException("Must define a single VelocityConfig bean in this web application context (may be inherited): VelocityConfigurer is the usual implementation. This bean may be given any name.", (Throwable)noSuchBeanDefinitionException);
        }
    }

    protected void checkTemplate() throws ApplicationContextException {
        try {
            this.template = this.getTemplate();
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            throw new ApplicationContextException("Cannot find Velocity template for URL [" + this.getUrl() + "]: Did you specify the correct resource loader path?", (Throwable)resourceNotFoundException);
        }
        catch (Exception exception) {
            throw new ApplicationContextException("Could not load Velocity template for URL [" + this.getUrl() + "]", (Throwable)exception);
        }
    }

    protected void renderMergedTemplateModel(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.exposeHelpers(map, httpServletRequest);
        Context context = this.createVelocityContext(map, httpServletRequest, httpServletResponse);
        this.exposeHelpers(context, httpServletRequest, httpServletResponse);
        this.exposeToolAttributes(context, httpServletRequest);
        this.doRender(context, httpServletResponse);
    }

    protected void exposeHelpers(Map map, HttpServletRequest httpServletRequest) throws Exception {
    }

    protected Context createVelocityContext(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        return this.createVelocityContext(map);
    }

    protected Context createVelocityContext(Map map) throws Exception {
        return new VelocityContext(map);
    }

    protected void exposeHelpers(Context context, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.exposeHelpers(context, httpServletRequest);
    }

    protected void exposeHelpers(Context context, HttpServletRequest httpServletRequest) throws Exception {
    }

    protected void exposeToolAttributes(Context context, HttpServletRequest httpServletRequest) throws Exception {
        Object object;
        if (this.toolAttributes != null) {
            object = this.toolAttributes.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                String string = (String)entry.getKey();
                Class clazz = (Class)entry.getValue();
                try {
                    Object t = clazz.newInstance();
                    this.initTool(t, context);
                    context.put(string, t);
                }
                catch (Exception exception) {
                    throw new NestedServletException("Could not instantiate Velocity tool '" + string + "'", (Throwable)exception);
                }
            }
        }
        if (this.velocityFormatterAttribute != null) {
            context.put(this.velocityFormatterAttribute, (Object)new VelocityFormatter(context));
        }
        if (this.dateToolAttribute != null || this.numberToolAttribute != null) {
            object = RequestContextUtils.getLocale(httpServletRequest);
            if (this.dateToolAttribute != null) {
                context.put(this.dateToolAttribute, (Object)new LocaleAwareDateTool((Locale)object));
            }
            if (this.numberToolAttribute != null) {
                context.put(this.numberToolAttribute, (Object)new LocaleAwareNumberTool((Locale)object));
            }
        }
    }

    protected void initTool(Object object, Context context) throws Exception {
    }

    protected void doRender(Context context, HttpServletResponse httpServletResponse) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering Velocity template [" + this.getUrl() + "] in VelocityView '" + this.getBeanName() + "'"));
        }
        this.mergeTemplate(this.getTemplate(), context, httpServletResponse);
    }

    protected Template getTemplate() throws Exception {
        if (this.isCacheTemplate() && this.template != null) {
            return this.template;
        }
        return this.getTemplate(this.getUrl());
    }

    protected Template getTemplate(String string) throws Exception {
        return this.getEncoding() != null ? this.getVelocityEngine().getTemplate(string, this.getEncoding()) : this.getVelocityEngine().getTemplate(string);
    }

    protected void mergeTemplate(Template template, Context context, HttpServletResponse httpServletResponse) throws Exception {
        try {
            template.merge(context, (Writer)httpServletResponse.getWriter());
        }
        catch (MethodInvocationException methodInvocationException) {
            throw new NestedServletException("Method invocation failed during rendering of Velocity view with name '" + this.getBeanName() + "': " + methodInvocationException.getMessage() + "; reference [" + methodInvocationException.getReferenceName() + "], method '" + methodInvocationException.getMethodName() + "'", methodInvocationException.getWrappedThrowable());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class LocaleAwareDateTool
    extends DateTool {
        private final Locale locale;

        private LocaleAwareDateTool(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }

    private static class LocaleAwareNumberTool
    extends NumberTool {
        private final Locale locale;

        private LocaleAwareNumberTool(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

