/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.velocity;

import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.view.velocity.VelocityToolboxView;

public class VelocityLayoutView
extends VelocityToolboxView {
    public static final String DEFAULT_LAYOUT_URL = "layout.vm";
    public static final String DEFAULT_LAYOUT_KEY = "layout";
    public static final String DEFAULT_SCREEN_CONTENT_KEY = "screen_content";
    private String layoutUrl = "layout.vm";
    private String layoutKey = "layout";
    private String screenContentKey = "screen_content";

    public void setLayoutUrl(String string) {
        this.layoutUrl = string;
    }

    public void setLayoutKey(String string) {
        this.layoutKey = string;
    }

    public void setScreenContentKey(String string) {
        this.screenContentKey = string;
    }

    protected void checkTemplate() throws ApplicationContextException {
        super.checkTemplate();
        try {
            this.getTemplate(this.layoutUrl);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            throw new ApplicationContextException("Cannot find Velocity template for URL [" + this.layoutUrl + "]: Did you specify the correct resource loader path?", (Throwable)resourceNotFoundException);
        }
        catch (Exception exception) {
            throw new ApplicationContextException("Could not load Velocity template for URL [" + this.layoutUrl + "]", (Throwable)exception);
        }
    }

    protected void doRender(Context context, HttpServletResponse httpServletResponse) throws Exception {
        this.renderScreenContent(context);
        String string = (String)context.get(this.layoutKey);
        if (string != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Screen content template has requested layout [" + string + "]"));
            }
        } else {
            string = this.layoutUrl;
        }
        this.mergeTemplate(this.getTemplate(string), context, httpServletResponse);
    }

    private void renderScreenContent(Context context) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering screen content template [" + this.getUrl() + "]"));
        }
        StringWriter stringWriter = new StringWriter();
        Template template = this.getTemplate(this.getUrl());
        template.merge(context, (Writer)stringWriter);
        context.put(this.screenContentKey, (Object)stringWriter.toString());
    }
}

