/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles;

import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.Controller;
import org.apache.struts.tiles.DefinitionsFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.view.InternalResourceView;

public class TilesView
extends InternalResourceView {
    public static final String PATH_ATTRIBUTE = (class$org$springframework$web$servlet$view$tiles$TilesView == null ? (class$org$springframework$web$servlet$view$tiles$TilesView = TilesView.class$("org.springframework.web.servlet.view.tiles.TilesView")) : class$org$springframework$web$servlet$view$tiles$TilesView).getName() + ".PATH";
    private DefinitionsFactory definitionsFactory;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$tiles$TilesView;

    public static void setPath(HttpServletRequest httpServletRequest, String string) {
        httpServletRequest.setAttribute(PATH_ATTRIBUTE, (Object)string);
    }

    protected void initApplicationContext() throws ApplicationContextException {
        super.initApplicationContext();
        this.definitionsFactory = (DefinitionsFactory)this.getServletContext().getAttribute("org.apache.struts.tiles.DEFINITIONS_FACTORY");
        if (this.definitionsFactory == null) {
            throw new ApplicationContextException("Tiles definitions factory not found: TilesConfigurer not defined?");
        }
    }

    protected String prepareForRendering(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        ComponentDefinition componentDefinition = this.getComponentDefinition(this.definitionsFactory, httpServletRequest);
        if (componentDefinition == null) {
            throw new ServletException("No Tiles definition found for name '" + this.getUrl() + "'");
        }
        ComponentContext componentContext = this.getComponentContext(componentDefinition, httpServletRequest);
        Controller controller = this.getController(componentDefinition, httpServletRequest);
        if (controller != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing Tiles controller [" + controller + "]"));
            }
            this.executeController(controller, componentContext, httpServletRequest, httpServletResponse);
        }
        if ((string = this.getDispatcherPath(componentDefinition, httpServletRequest)) == null) {
            throw new ServletException("Could not determine a path for Tiles definition '" + componentDefinition.getName() + "'");
        }
        return string;
    }

    protected ComponentDefinition getComponentDefinition(DefinitionsFactory definitionsFactory, HttpServletRequest httpServletRequest) throws Exception {
        return definitionsFactory.getDefinition(this.getUrl(), (ServletRequest)httpServletRequest, this.getServletContext());
    }

    protected ComponentContext getComponentContext(ComponentDefinition componentDefinition, HttpServletRequest httpServletRequest) throws Exception {
        ComponentContext componentContext = ComponentContext.getContext((ServletRequest)httpServletRequest);
        if (componentContext == null) {
            componentContext = new ComponentContext(componentDefinition.getAttributes());
            ComponentContext.setContext((ComponentContext)componentContext, (ServletRequest)httpServletRequest);
        } else {
            componentContext.addMissing(componentDefinition.getAttributes());
        }
        return componentContext;
    }

    protected Controller getController(ComponentDefinition componentDefinition, HttpServletRequest httpServletRequest) throws Exception {
        return componentDefinition.getOrCreateController();
    }

    protected void executeController(Controller controller, ComponentContext componentContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        controller.perform(componentContext, httpServletRequest, httpServletResponse, this.getServletContext());
    }

    protected String getDispatcherPath(ComponentDefinition componentDefinition, HttpServletRequest httpServletRequest) throws Exception {
        Object object = httpServletRequest.getAttribute(PATH_ATTRIBUTE);
        return object != null ? object.toString() : componentDefinition.getPath();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

