/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.jasperreports;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JasperPrint;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.view.jasperreports.AbstractJasperReportsView;

public class JasperReportsMultiFormatView
extends AbstractJasperReportsView {
    public static final String DEFAULT_FORMAT_KEY = "format";
    private String formatKey = "format";
    private Map formatMappings = new HashMap(4);
    private Properties contentDispositionMappings;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$jasperreports$JasperReportsCsvView;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$jasperreports$JasperReportsHtmlView;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$jasperreports$JasperReportsPdfView;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$jasperreports$JasperReportsXlsView;

    public JasperReportsMultiFormatView() {
        this.formatMappings.put("csv", class$org$springframework$web$servlet$view$jasperreports$JasperReportsCsvView == null ? (class$org$springframework$web$servlet$view$jasperreports$JasperReportsCsvView = JasperReportsMultiFormatView.class$("org.springframework.web.servlet.view.jasperreports.JasperReportsCsvView")) : class$org$springframework$web$servlet$view$jasperreports$JasperReportsCsvView);
        this.formatMappings.put("html", class$org$springframework$web$servlet$view$jasperreports$JasperReportsHtmlView == null ? (class$org$springframework$web$servlet$view$jasperreports$JasperReportsHtmlView = JasperReportsMultiFormatView.class$("org.springframework.web.servlet.view.jasperreports.JasperReportsHtmlView")) : class$org$springframework$web$servlet$view$jasperreports$JasperReportsHtmlView);
        this.formatMappings.put("pdf", class$org$springframework$web$servlet$view$jasperreports$JasperReportsPdfView == null ? (class$org$springframework$web$servlet$view$jasperreports$JasperReportsPdfView = JasperReportsMultiFormatView.class$("org.springframework.web.servlet.view.jasperreports.JasperReportsPdfView")) : class$org$springframework$web$servlet$view$jasperreports$JasperReportsPdfView);
        this.formatMappings.put("xls", class$org$springframework$web$servlet$view$jasperreports$JasperReportsXlsView == null ? (class$org$springframework$web$servlet$view$jasperreports$JasperReportsXlsView = JasperReportsMultiFormatView.class$("org.springframework.web.servlet.view.jasperreports.JasperReportsXlsView")) : class$org$springframework$web$servlet$view$jasperreports$JasperReportsXlsView);
    }

    public void setFormatKey(String string) {
        this.formatKey = string;
    }

    public void setFormatMappings(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("formatMappings must not be empty");
        }
        this.formatMappings = new HashMap(properties.size());
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Mapped view class [" + string2 + "] to mapping key [" + string + "]"));
                }
                this.formatMappings.put(string, ClassUtils.forName((String)string2));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ApplicationContextException("Class [" + string2 + "] mapped to format [" + string + "] cannot be found", (Throwable)classNotFoundException);
            }
        }
    }

    public void setContentDispositionMappings(Properties properties) {
        this.contentDispositionMappings = properties;
    }

    public Properties getContentDispositionMappings() {
        if (this.contentDispositionMappings == null) {
            this.contentDispositionMappings = new Properties();
        }
        return this.contentDispositionMappings;
    }

    protected void renderReport(JasperPrint jasperPrint, Map map, HttpServletResponse httpServletResponse) throws Exception {
        Class clazz;
        String string = (String)map.get(this.formatKey);
        if (string == null) {
            throw new IllegalArgumentException("No format format found in model");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering report using format mapping key [" + string + "]"));
        }
        if ((clazz = (Class)this.formatMappings.get(string)) == null) {
            throw new IllegalArgumentException("Format discriminator [" + string + "] is not a configured mapping");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering report using view class [" + clazz.getName() + "]"));
        }
        AbstractJasperReportsView abstractJasperReportsView = (AbstractJasperReportsView)BeanUtils.instantiateClass((Class)clazz);
        abstractJasperReportsView.setExporterParameters(this.getExporterParameters());
        abstractJasperReportsView.convertExporterParameters();
        this.populateContentDispositionIfNecessary(httpServletResponse, string);
        abstractJasperReportsView.renderReport(jasperPrint, map, httpServletResponse);
    }

    private void populateContentDispositionIfNecessary(HttpServletResponse httpServletResponse, String string) {
        String string2;
        if (this.contentDispositionMappings != null && (string2 = this.contentDispositionMappings.getProperty(string)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting Content-Disposition header to: [" + string2 + "]"));
            }
            httpServletResponse.setHeader("Content-Disposition", string2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

