/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.jasperreports;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataSourceProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRDefaultCompiler;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceResourceBundle;
import org.springframework.core.io.Resource;
import org.springframework.ui.jasperreports.JasperReportsUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public abstract class AbstractJasperReportsView
extends AbstractUrlBasedView {
    protected static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    protected static final String CONTENT_DISPOSITION_INLINE = "inline";
    private String reportDataKey;
    private Properties subReportUrls;
    private String[] subReportDataKeys;
    private Properties headers;
    private Map exporterParameters = new HashMap();
    private Map convertedExporterParameters;
    private DataSource jdbcDataSource;
    private JRCompiler reportCompiler = JRDefaultCompiler.getInstance();
    private JasperReport report;
    private Map subReports;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$JRExporterParameter;
    static /* synthetic */ Class class$javax$sql$DataSource;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$JRDataSource;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$JRDataSourceProvider;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public void setReportDataKey(String string) {
        this.reportDataKey = string;
    }

    public void setSubReportUrls(Properties properties) {
        this.subReportUrls = properties;
    }

    public void setSubReportDataKeys(String[] stringArray) {
        this.subReportDataKeys = stringArray;
    }

    public void setHeaders(Properties properties) {
        this.headers = properties;
    }

    public void setExporterParameters(Map map) {
        this.exporterParameters = map;
    }

    public Map getExporterParameters() {
        return this.exporterParameters;
    }

    protected Map getConvertedExporterParameters() {
        return this.convertedExporterParameters;
    }

    public void setJdbcDataSource(DataSource dataSource) {
        this.jdbcDataSource = dataSource;
    }

    protected DataSource getJdbcDataSource() {
        return this.jdbcDataSource;
    }

    public void setReportCompiler(JRCompiler jRCompiler) {
        this.reportCompiler = jRCompiler != null ? jRCompiler : JRDefaultCompiler.getInstance();
    }

    protected JRCompiler getReportCompiler() {
        return this.reportCompiler;
    }

    protected final void initApplicationContext() throws ApplicationContextException {
        Resource resource = this.getApplicationContext().getResource(this.getUrl());
        this.report = this.loadReport(resource);
        if (this.subReportUrls != null) {
            if (this.subReportDataKeys != null && this.subReportDataKeys.length > 0 && this.reportDataKey == null) {
                throw new ApplicationContextException("'reportDataKey' for main report is required when specifying a value for 'subReportDataKeys'");
            }
            this.subReports = new HashMap(this.subReportUrls.size());
            Enumeration<?> enumeration = this.subReportUrls.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = this.subReportUrls.getProperty(string);
                Resource resource2 = this.getApplicationContext().getResource(string2);
                this.subReports.put(string, this.loadReport(resource2));
            }
        }
        this.convertExporterParameters();
        if (this.headers == null) {
            this.headers = new Properties();
        }
        if (!this.headers.containsKey(HEADER_CONTENT_DISPOSITION)) {
            this.headers.setProperty(HEADER_CONTENT_DISPOSITION, CONTENT_DISPOSITION_INLINE);
        }
        this.onInit();
    }

    protected void onInit() {
    }

    protected final void convertExporterParameters() {
        if (this.exporterParameters != null && !this.exporterParameters.isEmpty()) {
            this.convertedExporterParameters = new HashMap(this.exporterParameters.size());
            Iterator iterator = this.exporterParameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                JRExporterParameter jRExporterParameter = this.getExporterParameter(entry.getKey());
                this.convertedExporterParameters.put(jRExporterParameter, this.convertParameterValue(jRExporterParameter, entry.getValue()));
            }
        }
    }

    protected Object convertParameterValue(JRExporterParameter jRExporterParameter, Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if ("true".equals(string)) {
                return Boolean.TRUE;
            }
            if ("false".equals(string)) {
                return Boolean.FALSE;
            }
            if (string.length() > 0 && Character.isDigit(string.charAt(0))) {
                try {
                    return new Integer(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return string;
                }
            }
        }
        return object;
    }

    protected JRExporterParameter getExporterParameter(Object object) {
        if (object instanceof JRExporterParameter) {
            return (JRExporterParameter)object;
        }
        if (object instanceof String) {
            return this.convertToExporterParameter((String)object);
        }
        throw new IllegalArgumentException("Parameter [" + object + "] is invalid type. Should be either String or JRExporterParameter.");
    }

    protected JRExporterParameter convertToExporterParameter(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1 || n == string.length()) {
            throw new IllegalArgumentException("Parameter name [" + string + "] is not a valid static field. " + "The parameter name must map to a static field such as " + "[net.sf.jasperreports.engine.export.JRHtmlExporterParameter.IMAGES_URI]");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            Class clazz = ClassUtils.forName((String)string2);
            Field field = clazz.getField(string3);
            if ((class$net$sf$jasperreports$engine$JRExporterParameter == null ? (class$net$sf$jasperreports$engine$JRExporterParameter = AbstractJasperReportsView.class$("net.sf.jasperreports.engine.JRExporterParameter")) : class$net$sf$jasperreports$engine$JRExporterParameter).isAssignableFrom(field.getType())) {
                try {
                    return (JRExporterParameter)field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalArgumentException("Unable to access field [" + string3 + "] of class [" + string2 + "]. " + "Check that it is static and accessible.");
                }
            }
            throw new IllegalArgumentException("Field [" + string3 + "] on class [" + string2 + "] is not assignable from JRExporterParameter - check the type of this field.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Class [" + string2 + "] in key [" + string + "] could not be found.");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException("Field [" + string3 + "] in key [" + string + "] could not be found on class [" + string2 + "].");
        }
    }

    private JasperReport loadReport(Resource resource) throws ApplicationContextException {
        try {
            String string = resource.getFilename();
            if (string.endsWith(".jasper")) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Loading pre-compiled Jasper Report from " + resource));
                }
                return (JasperReport)JRLoader.loadObject((InputStream)resource.getInputStream());
            }
            if (string.endsWith(".jrxml")) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Compiling Jasper Report loaded from " + resource));
                }
                JasperDesign jasperDesign = JRXmlLoader.load((InputStream)resource.getInputStream());
                return this.getReportCompiler().compileReport(jasperDesign);
            }
            throw new IllegalArgumentException("Report URL [" + this.getUrl() + "] must end in either .jasper or .jrxml");
        }
        catch (IOException iOException) {
            throw new ApplicationContextException("Could not load JasperReports report for URL [" + this.getUrl() + "]", (Throwable)iOException);
        }
        catch (JRException jRException) {
            throw new ApplicationContextException("Could not parse JasperReports report for URL [" + this.getUrl() + "]", (Throwable)jRException);
        }
    }

    protected void renderMergedOutputModel(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (this.subReports != null) {
            map.putAll(this.subReports);
            if (this.subReportDataKeys != null) {
                for (int i = 0; i < this.subReportDataKeys.length; ++i) {
                    String string = this.subReportDataKeys[i];
                    map.put(string, this.convertReportData(map.get(string)));
                }
            }
        }
        this.exposeLocalizationContext(map, httpServletRequest);
        JasperPrint jasperPrint = this.fillReport(map);
        this.postProcessReport(jasperPrint, map);
        httpServletResponse.reset();
        this.populateHeaders(httpServletResponse);
        this.renderReport(jasperPrint, map, httpServletResponse);
    }

    protected void exposeLocalizationContext(Map map, HttpServletRequest httpServletRequest) {
        Locale locale = RequestContextUtils.getLocale(httpServletRequest);
        map.put("REPORT_LOCALE", locale);
        if (this.report.getResourceBundle() == null) {
            MessageSourceResourceBundle messageSourceResourceBundle = new MessageSourceResourceBundle((MessageSource)this.getApplicationContext(), locale);
            map.put("REPORT_RESOURCE_BUNDLE", messageSourceResourceBundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JasperPrint fillReport(Map map) throws IllegalArgumentException, SQLException, JRException {
        JRDataSource jRDataSource = this.getReportData(map);
        if (jRDataSource != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Filling report with JRDataSource [" + jRDataSource + "]."));
            }
            return JasperFillManager.fillReport((JasperReport)this.report, (Map)map, (JRDataSource)jRDataSource);
        }
        if (this.jdbcDataSource == null) {
            this.jdbcDataSource = (DataSource)CollectionUtils.findValueOfType(map.values(), (Class)(class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = AbstractJasperReportsView.class$("javax.sql.DataSource")) : class$javax$sql$DataSource));
        }
        if (this.jdbcDataSource != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Filling report with JDBC DataSource [" + this.jdbcDataSource + "]."));
            }
            Connection connection = this.jdbcDataSource.getConnection();
            try {
                JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)this.report, (Map)map, (Connection)connection);
                return jasperPrint;
            }
            finally {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    this.logger.debug((Object)"Could not close JDBC Connection", (Throwable)sQLException);
                }
            }
        }
        return JasperFillManager.fillReport((JasperReport)this.report, (Map)map);
    }

    private void populateHeaders(HttpServletResponse httpServletResponse) {
        Enumeration<?> enumeration = this.headers.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            httpServletResponse.addHeader(string, this.headers.getProperty(string));
        }
    }

    protected JRDataSource getReportData(Map map) {
        if (this.reportDataKey != null) {
            Object v = map.get(this.reportDataKey);
            return this.convertReportData(v);
        }
        Object object = CollectionUtils.findValueOfType(map.values(), (Class[])this.getReportDataTypes());
        if (object != null) {
            return this.convertReportData(object);
        }
        return null;
    }

    protected JRDataSource convertReportData(Object object) throws IllegalArgumentException {
        if (object instanceof JRDataSourceProvider) {
            try {
                return ((JRDataSourceProvider)object).create(this.report);
            }
            catch (JRException jRException) {
                throw new IllegalArgumentException("Supplied JRDataSourceProvider is invalid: " + (Object)((Object)jRException));
            }
        }
        return JasperReportsUtils.convertReportData((Object)object);
    }

    protected Class[] getReportDataTypes() {
        return new Class[]{class$net$sf$jasperreports$engine$JRDataSource == null ? (class$net$sf$jasperreports$engine$JRDataSource = AbstractJasperReportsView.class$("net.sf.jasperreports.engine.JRDataSource")) : class$net$sf$jasperreports$engine$JRDataSource, class$net$sf$jasperreports$engine$JRDataSourceProvider == null ? (class$net$sf$jasperreports$engine$JRDataSourceProvider = AbstractJasperReportsView.class$("net.sf.jasperreports.engine.JRDataSourceProvider")) : class$net$sf$jasperreports$engine$JRDataSourceProvider, class$java$util$Collection == null ? (class$java$util$Collection = AbstractJasperReportsView.class$("java.util.Collection")) : class$java$util$Collection, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbstractJasperReportsView.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object};
    }

    protected JasperReport getReport() {
        return this.report;
    }

    protected void postProcessReport(JasperPrint jasperPrint, Map map) throws Exception {
    }

    protected abstract void renderReport(JasperPrint var1, Map var2, HttpServletResponse var3) throws Exception;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

