/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.jasperreports;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import org.springframework.ui.jasperreports.JasperReportsUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.view.jasperreports.AbstractJasperReportsView;

public abstract class AbstractJasperReportsSingleFormatView
extends AbstractJasperReportsView {
    private static final int OUTPUT_BYTE_ARRAY_INITIAL_SIZE = 4096;

    protected void renderReport(JasperPrint jasperPrint, Map map, HttpServletResponse httpServletResponse) throws Exception {
        JRExporter jRExporter = this.createExporter();
        Map map2 = this.mergeExporterParameters(map);
        if (!CollectionUtils.isEmpty((Map)map2)) {
            jRExporter.setParameters(map2);
        }
        if (this.useWriter()) {
            String string = this.getContentType();
            String string2 = (String)jRExporter.getParameter(JRExporterParameter.CHARACTER_ENCODING);
            if (string2 != null && string != null && string.toLowerCase().indexOf(";charset=") == -1) {
                string = string + ";charset=" + string2;
            }
            httpServletResponse.setContentType(string);
            JasperReportsUtils.render((JRExporter)jRExporter, (JasperPrint)jasperPrint, (Writer)httpServletResponse.getWriter());
        } else {
            httpServletResponse.setContentType(this.getContentType());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
            JasperReportsUtils.render((JRExporter)jRExporter, (JasperPrint)jasperPrint, (OutputStream)byteArrayOutputStream);
            httpServletResponse.setContentLength(byteArrayOutputStream.size());
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            byteArrayOutputStream.writeTo((OutputStream)servletOutputStream);
            servletOutputStream.flush();
        }
    }

    protected Map mergeExporterParameters(Map map) {
        HashMap hashMap = new HashMap();
        Map map2 = this.getConvertedExporterParameters();
        if (!CollectionUtils.isEmpty((Map)map2)) {
            hashMap.putAll(map2);
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(k instanceof JRExporterParameter)) continue;
            Object v = map.get(k);
            if (v instanceof String) {
                hashMap.put(k, v);
                continue;
            }
            if (!this.logger.isWarnEnabled()) continue;
            this.logger.warn((Object)("Ignoring exporter parameter [" + k + "]: value is not a String"));
        }
        return hashMap;
    }

    protected abstract JRExporter createExporter();

    protected abstract boolean useWriter();
}

