/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.freemarker;

import freemarker.core.ParseException;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.HttpRequestParametersHashModel;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractTemplateView;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

public class FreeMarkerView
extends AbstractTemplateView {
    private String encoding;
    private Configuration configuration;
    private TaglibFactory taglibFactory;
    private ServletContextHashModel servletContextHashModel;
    static /* synthetic */ Class class$org$springframework$web$servlet$view$freemarker$FreeMarkerConfig;

    public void setEncoding(String string) {
        this.encoding = string;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected void initApplicationContext() throws BeansException {
        Object object;
        super.initApplicationContext();
        if (this.getConfiguration() != null) {
            this.taglibFactory = new TaglibFactory(this.getServletContext());
        } else {
            object = this.autodetectConfiguration();
            this.setConfiguration(object.getConfiguration());
            this.taglibFactory = object.getTaglibFactory();
        }
        object = new GenericServletAdapter();
        try {
            object.init(new DelegatingServletConfig());
        }
        catch (ServletException servletException) {
            throw new BeanInitializationException("Initialization of GenericServlet adapter failed", (Throwable)servletException);
        }
        this.servletContextHashModel = new ServletContextHashModel((GenericServlet)object, this.getObjectWrapper());
        this.checkTemplate();
    }

    protected FreeMarkerConfig autodetectConfiguration() throws BeansException {
        try {
            return (FreeMarkerConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), (Class)(class$org$springframework$web$servlet$view$freemarker$FreeMarkerConfig == null ? (class$org$springframework$web$servlet$view$freemarker$FreeMarkerConfig = FreeMarkerView.class$("org.springframework.web.servlet.view.freemarker.FreeMarkerConfig")) : class$org$springframework$web$servlet$view$freemarker$FreeMarkerConfig), (boolean)true, (boolean)false);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            throw new ApplicationContextException("Must define a single FreeMarkerConfig bean in this web application context (may be inherited): FreeMarkerConfigurer is the usual implementation. This bean may be given any name.", (Throwable)noSuchBeanDefinitionException);
        }
    }

    protected ObjectWrapper getObjectWrapper() {
        ObjectWrapper objectWrapper = this.getConfiguration().getObjectWrapper();
        return objectWrapper != null ? objectWrapper : ObjectWrapper.DEFAULT_WRAPPER;
    }

    protected void checkTemplate() throws ApplicationContextException {
        try {
            this.getTemplate(this.getConfiguration().getLocale());
        }
        catch (ParseException parseException) {
            throw new ApplicationContextException("Failed to parse FreeMarker template for URL [" + this.getUrl() + "]", (Throwable)parseException);
        }
        catch (IOException iOException) {
            throw new ApplicationContextException("Could not load FreeMarker template for URL [" + this.getUrl() + "]", (Throwable)iOException);
        }
    }

    protected void renderMergedTemplateModel(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.exposeHelpers(map, httpServletRequest);
        this.doRender(map, httpServletRequest, httpServletResponse);
    }

    protected void exposeHelpers(Map map, HttpServletRequest httpServletRequest) throws Exception {
    }

    protected void doRender(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.exposeModelAsRequestAttributes(map, httpServletRequest);
        map.put("JspTaglibs", this.taglibFactory);
        map.put("Application", this.servletContextHashModel);
        map.put("Session", this.buildSessionModel(httpServletRequest, httpServletResponse));
        map.put("Request", new HttpRequestHashModel(httpServletRequest, httpServletResponse, this.getObjectWrapper()));
        map.put("RequestParameters", new HttpRequestParametersHashModel(httpServletRequest));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering FreeMarker template [" + this.getUrl() + "] in FreeMarkerView '" + this.getBeanName() + "'"));
        }
        Locale locale = RequestContextUtils.getLocale(httpServletRequest);
        this.processTemplate(this.getTemplate(locale), map, httpServletResponse);
    }

    private HttpSessionHashModel buildSessionModel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            return new HttpSessionHashModel(httpSession, this.getObjectWrapper());
        }
        return new HttpSessionHashModel(null, httpServletRequest, httpServletResponse, this.getObjectWrapper());
    }

    protected Template getTemplate(Locale locale) throws IOException {
        return this.getTemplate(this.getUrl(), locale);
    }

    protected Template getTemplate(String string, Locale locale) throws IOException {
        return this.getEncoding() != null ? this.getConfiguration().getTemplate(string, locale, this.getEncoding()) : this.getConfiguration().getTemplate(string, locale);
    }

    protected void processTemplate(Template template, Map map, HttpServletResponse httpServletResponse) throws IOException, TemplateException {
        template.process((Object)map, (Writer)httpServletResponse.getWriter());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        public String getServletName() {
            return FreeMarkerView.this.getBeanName();
        }

        public ServletContext getServletContext() {
            return FreeMarkerView.this.getServletContext();
        }

        public String getInitParameter(String string) {
            return null;
        }

        public Enumeration getInitParameterNames() {
            return Collections.enumeration(Collections.EMPTY_SET);
        }
    }

    private static class GenericServletAdapter
    extends GenericServlet {
        private GenericServletAdapter() {
        }

        public void service(ServletRequest servletRequest, ServletResponse servletResponse) {
        }
    }
}

