/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.document;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.view.AbstractView;

public abstract class AbstractPdfView
extends AbstractView {
    private static final int OUTPUT_BYTE_ARRAY_INITIAL_SIZE = 4096;

    public AbstractPdfView() {
        this.setContentType("application/pdf");
    }

    protected final void renderMergedOutputModel(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        Document document = this.newDocument();
        PdfWriter pdfWriter = this.newWriter(document, byteArrayOutputStream);
        this.prepareWriter(map, pdfWriter, httpServletRequest);
        this.buildPdfMetadata(map, document, httpServletRequest);
        document.open();
        this.buildPdfDocument(map, document, pdfWriter, httpServletRequest, httpServletResponse);
        document.close();
        httpServletResponse.setContentType(this.getContentType());
        httpServletResponse.setContentLength(byteArrayOutputStream.size());
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        byteArrayOutputStream.writeTo((OutputStream)servletOutputStream);
        servletOutputStream.flush();
    }

    protected Document newDocument() {
        return new Document(PageSize.A4);
    }

    protected PdfWriter newWriter(Document document, OutputStream outputStream) throws DocumentException {
        return PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
    }

    protected void prepareWriter(Map map, PdfWriter pdfWriter, HttpServletRequest httpServletRequest) throws DocumentException {
        pdfWriter.setViewerPreferences(this.getViewerPreferences());
    }

    protected int getViewerPreferences() {
        return 2053;
    }

    protected void buildPdfMetadata(Map map, Document document, HttpServletRequest httpServletRequest) {
    }

    protected abstract void buildPdfDocument(Map var1, Document var2, PdfWriter var3, HttpServletRequest var4, HttpServletResponse var5) throws Exception;
}

