/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.document;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jxl.Workbook;
import jxl.write.WritableWorkbook;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.LocalizedResourceHelper;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractView;

public abstract class AbstractJExcelView
extends AbstractView {
    private static final String CONTENT_TYPE = "application/vnd.ms-excel";
    private static final String EXTENSION = ".xls";
    private String url;

    public AbstractJExcelView() {
        this.setContentType(CONTENT_TYPE);
    }

    public void setUrl(String string) {
        this.url = string;
    }

    protected final void renderMergedOutputModel(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        WritableWorkbook writableWorkbook;
        httpServletResponse.setContentType(this.getContentType());
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (this.url != null) {
            Workbook workbook = this.getTemplateSource(this.url, httpServletRequest);
            writableWorkbook = Workbook.createWorkbook((OutputStream)servletOutputStream, (Workbook)workbook);
        } else {
            this.logger.debug((Object)"Creating Excel Workbook from scratch");
            writableWorkbook = Workbook.createWorkbook((OutputStream)servletOutputStream);
        }
        this.buildExcelDocument(map, writableWorkbook, httpServletRequest, httpServletResponse);
        writableWorkbook.write();
        servletOutputStream.flush();
        writableWorkbook.close();
    }

    protected Workbook getTemplateSource(String string, HttpServletRequest httpServletRequest) throws Exception {
        LocalizedResourceHelper localizedResourceHelper = new LocalizedResourceHelper((ResourceLoader)this.getApplicationContext());
        Locale locale = RequestContextUtils.getLocale(httpServletRequest);
        Resource resource = localizedResourceHelper.findLocalizedResource(string, EXTENSION, locale);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loading Excel workbook from " + resource));
        }
        return Workbook.getWorkbook((InputStream)resource.getInputStream());
    }

    protected abstract void buildExcelDocument(Map var1, WritableWorkbook var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;
}

