/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.document;

import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.LocalizedResourceHelper;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractView;

public abstract class AbstractExcelView
extends AbstractView {
    private static final String CONTENT_TYPE = "application/vnd.ms-excel";
    private static final String EXTENSION = ".xls";
    private String url;

    public AbstractExcelView() {
        this.setContentType(CONTENT_TYPE);
    }

    public void setUrl(String string) {
        this.url = string;
    }

    protected final void renderMergedOutputModel(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HSSFWorkbook hSSFWorkbook;
        if (this.url != null) {
            hSSFWorkbook = this.getTemplateSource(this.url, httpServletRequest);
        } else {
            hSSFWorkbook = new HSSFWorkbook();
            this.logger.debug((Object)"Created Excel Workbook from scratch");
        }
        this.buildExcelDocument(map, hSSFWorkbook, httpServletRequest, httpServletResponse);
        httpServletResponse.setContentType(this.getContentType());
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        hSSFWorkbook.write((OutputStream)servletOutputStream);
        servletOutputStream.flush();
    }

    protected HSSFWorkbook getTemplateSource(String string, HttpServletRequest httpServletRequest) throws Exception {
        LocalizedResourceHelper localizedResourceHelper = new LocalizedResourceHelper((ResourceLoader)this.getApplicationContext());
        Locale locale = RequestContextUtils.getLocale(httpServletRequest);
        Resource resource = localizedResourceHelper.findLocalizedResource(string, EXTENSION, locale);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loading Excel workbook from " + resource));
        }
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(resource.getInputStream());
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(pOIFSFileSystem);
        return hSSFWorkbook;
    }

    protected abstract void buildExcelDocument(Map var1, HSSFWorkbook var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected HSSFCell getCell(HSSFSheet hSSFSheet, int n, int n2) {
        HSSFCell hSSFCell;
        HSSFRow hSSFRow = hSSFSheet.getRow(n);
        if (hSSFRow == null) {
            hSSFRow = hSSFSheet.createRow(n);
        }
        if ((hSSFCell = hSSFRow.getCell((short)n2)) == null) {
            hSSFCell = hSSFRow.createCell((short)n2);
        }
        return hSSFCell;
    }

    protected void setText(HSSFCell hSSFCell, String string) {
        hSSFCell.setCellType(1);
        hSSFCell.setCellValue(string);
    }
}

