/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.Locale;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractCachingViewResolver;
import org.xml.sax.EntityResolver;

public class XmlViewResolver
extends AbstractCachingViewResolver
implements Ordered,
DisposableBean {
    public static final String DEFAULT_LOCATION = "/WEB-INF/views.xml";
    private int order = Integer.MAX_VALUE;
    private Resource location;
    private ConfigurableApplicationContext cachedFactory;
    static /* synthetic */ Class class$org$springframework$web$servlet$View;

    public void setOrder(int n) {
        this.order = n;
    }

    public int getOrder() {
        return this.order;
    }

    public void setLocation(Resource resource) {
        this.location = resource;
    }

    protected void initApplicationContext() throws BeansException {
        if (this.isCache()) {
            this.initFactory();
        }
    }

    protected Object getCacheKey(String string, Locale locale) {
        return string;
    }

    protected View loadView(String string, Locale locale) throws BeansException {
        BeanFactory beanFactory = this.initFactory();
        try {
            return (View)beanFactory.getBean(string, class$org$springframework$web$servlet$View == null ? (class$org$springframework$web$servlet$View = XmlViewResolver.class$("org.springframework.web.servlet.View")) : class$org$springframework$web$servlet$View);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            return null;
        }
    }

    protected synchronized BeanFactory initFactory() throws BeansException {
        if (this.cachedFactory != null) {
            return this.cachedFactory;
        }
        Resource resource = this.location;
        if (resource == null) {
            resource = this.getApplicationContext().getResource(DEFAULT_LOCATION);
        }
        GenericWebApplicationContext genericWebApplicationContext = new GenericWebApplicationContext();
        genericWebApplicationContext.setParent(this.getApplicationContext());
        genericWebApplicationContext.setServletContext(this.getServletContext());
        XmlBeanDefinitionReader xmlBeanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)genericWebApplicationContext);
        xmlBeanDefinitionReader.setEntityResolver((EntityResolver)new ResourceEntityResolver((ResourceLoader)this.getApplicationContext()));
        xmlBeanDefinitionReader.loadBeanDefinitions(resource);
        genericWebApplicationContext.refresh();
        if (this.isCache()) {
            this.cachedFactory = genericWebApplicationContext;
        }
        return genericWebApplicationContext;
    }

    public void destroy() throws BeansException {
        if (this.cachedFactory != null) {
            this.cachedFactory.close();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

