/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeanUtils;
import org.springframework.core.Ordered;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractCachingViewResolver;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.InternalResourceView;
import org.springframework.web.servlet.view.RedirectView;

public class UrlBasedViewResolver
extends AbstractCachingViewResolver
implements Ordered {
    public static final String REDIRECT_URL_PREFIX = "redirect:";
    public static final String FORWARD_URL_PREFIX = "forward:";
    private Class viewClass;
    private String prefix = "";
    private String suffix = "";
    private String[] viewNames = null;
    private String contentType;
    private boolean redirectContextRelative = true;
    private boolean redirectHttp10Compatible = true;
    private String requestContextAttribute;
    private int order = Integer.MAX_VALUE;
    private final Map staticAttributes = new HashMap();
    static /* synthetic */ Class class$org$springframework$web$servlet$view$AbstractUrlBasedView;

    public void setViewClass(Class clazz) {
        if (clazz == null || !this.requiredViewClass().isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Given view class [" + (clazz != null ? clazz.getName() : null) + "] is not of type [" + this.requiredViewClass().getName() + "]");
        }
        this.viewClass = clazz;
    }

    protected Class getViewClass() {
        return this.viewClass;
    }

    protected Class requiredViewClass() {
        return class$org$springframework$web$servlet$view$AbstractUrlBasedView == null ? (class$org$springframework$web$servlet$view$AbstractUrlBasedView = UrlBasedViewResolver.class$("org.springframework.web.servlet.view.AbstractUrlBasedView")) : class$org$springframework$web$servlet$view$AbstractUrlBasedView;
    }

    public void setPrefix(String string) {
        this.prefix = string != null ? string : "";
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public void setSuffix(String string) {
        this.suffix = string != null ? string : "";
    }

    protected String getSuffix() {
        return this.suffix;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    protected String getContentType() {
        return this.contentType;
    }

    public void setRedirectContextRelative(boolean bl) {
        this.redirectContextRelative = bl;
    }

    protected boolean isRedirectContextRelative() {
        return this.redirectContextRelative;
    }

    public void setRedirectHttp10Compatible(boolean bl) {
        this.redirectHttp10Compatible = bl;
    }

    protected boolean isRedirectHttp10Compatible() {
        return this.redirectHttp10Compatible;
    }

    public void setRequestContextAttribute(String string) {
        this.requestContextAttribute = string;
    }

    protected String getRequestContextAttribute() {
        return this.requestContextAttribute;
    }

    public void setAttributes(Properties properties) {
        this.setAttributesMap(properties);
    }

    public void setAttributesMap(Map map) {
        if (map != null) {
            this.staticAttributes.putAll(map);
        }
    }

    public Map getAttributesMap() {
        return this.staticAttributes;
    }

    public void setViewNames(String[] stringArray) {
        this.viewNames = stringArray;
    }

    protected String[] getViewNames() {
        return this.viewNames;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public int getOrder() {
        return this.order;
    }

    protected void initApplicationContext() {
        super.initApplicationContext();
        if (this.getViewClass() == null) {
            throw new IllegalArgumentException("Property 'viewClass' is required");
        }
    }

    protected Object getCacheKey(String string, Locale locale) {
        return string;
    }

    protected View createView(String string, Locale locale) throws Exception {
        if (!this.canHandle(string, locale)) {
            return null;
        }
        if (string.startsWith(REDIRECT_URL_PREFIX)) {
            String string2 = string.substring(REDIRECT_URL_PREFIX.length());
            return new RedirectView(string2, this.isRedirectContextRelative(), this.isRedirectHttp10Compatible());
        }
        if (string.startsWith(FORWARD_URL_PREFIX)) {
            String string3 = string.substring(FORWARD_URL_PREFIX.length());
            return new InternalResourceView(string3);
        }
        return super.createView(string, locale);
    }

    protected boolean canHandle(String string, Locale locale) {
        String[] stringArray = this.getViewNames();
        return stringArray == null || PatternMatchUtils.simpleMatch((String[])stringArray, (String)string);
    }

    protected View loadView(String string, Locale locale) throws Exception {
        AbstractUrlBasedView abstractUrlBasedView = this.buildView(string);
        return (View)this.getApplicationContext().getAutowireCapableBeanFactory().initializeBean((Object)abstractUrlBasedView, string);
    }

    protected AbstractUrlBasedView buildView(String string) throws Exception {
        AbstractUrlBasedView abstractUrlBasedView = (AbstractUrlBasedView)BeanUtils.instantiateClass((Class)this.getViewClass());
        abstractUrlBasedView.setUrl(this.getPrefix() + string + this.getSuffix());
        String string2 = this.getContentType();
        if (string2 != null) {
            abstractUrlBasedView.setContentType(string2);
        }
        abstractUrlBasedView.setRequestContextAttribute(this.getRequestContextAttribute());
        abstractUrlBasedView.setAttributesMap(this.getAttributesMap());
        return abstractUrlBasedView;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

