/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.PropertiesBeanDefinitionReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractCachingViewResolver;

public class ResourceBundleViewResolver
extends AbstractCachingViewResolver
implements Ordered,
DisposableBean {
    public static final String DEFAULT_BASENAME = "views";
    private int order = Integer.MAX_VALUE;
    private String[] basenames = new String[]{"views"};
    private ClassLoader bundleClassLoader = Thread.currentThread().getContextClassLoader();
    private String defaultParentView;
    private Locale[] localesToInitialize;
    private final Map localeCache = new HashMap();
    private final Map bundleCache = new HashMap();
    static /* synthetic */ Class class$org$springframework$web$servlet$View;

    public void setOrder(int n) {
        this.order = n;
    }

    public int getOrder() {
        return this.order;
    }

    public void setBasename(String string) {
        this.setBasenames(new String[]{string});
    }

    public void setBasenames(String[] stringArray) {
        this.basenames = stringArray;
    }

    public void setBundleClassLoader(ClassLoader classLoader) {
        this.bundleClassLoader = classLoader;
    }

    protected ClassLoader getBundleClassLoader() {
        return this.bundleClassLoader;
    }

    public void setDefaultParentView(String string) {
        this.defaultParentView = string;
    }

    public void setLocalesToInitialize(Locale[] localeArray) {
        this.localesToInitialize = localeArray;
    }

    protected void initApplicationContext() throws BeansException {
        if (this.localesToInitialize != null) {
            for (int i = 0; i < this.localesToInitialize.length; ++i) {
                this.initFactory(this.localesToInitialize[i]);
            }
        }
    }

    protected View loadView(String string, Locale locale) throws Exception {
        BeanFactory beanFactory = this.initFactory(locale);
        try {
            return (View)beanFactory.getBean(string, class$org$springframework$web$servlet$View == null ? (class$org$springframework$web$servlet$View = ResourceBundleViewResolver.class$("org.springframework.web.servlet.View")) : class$org$springframework$web$servlet$View);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            return null;
        }
    }

    protected synchronized BeanFactory initFactory(Locale locale) throws BeansException {
        BeanFactory beanFactory;
        ResourceBundle resourceBundle;
        BeanFactory beanFactory2;
        if (this.isCache() && (beanFactory2 = (BeanFactory)this.localeCache.get(locale)) != null) {
            return beanFactory2;
        }
        beanFactory2 = new LinkedList();
        for (int i = 0; i < this.basenames.length; ++i) {
            resourceBundle = this.getBundle(this.basenames[i], locale);
            beanFactory2.add(resourceBundle);
        }
        if (this.isCache() && (beanFactory = (BeanFactory)this.bundleCache.get(beanFactory2)) != null) {
            this.localeCache.put(locale, beanFactory);
            return beanFactory;
        }
        GenericWebApplicationContext genericWebApplicationContext = new GenericWebApplicationContext();
        genericWebApplicationContext.setParent(this.getApplicationContext());
        genericWebApplicationContext.setServletContext(this.getServletContext());
        resourceBundle = new PropertiesBeanDefinitionReader((BeanDefinitionRegistry)genericWebApplicationContext);
        resourceBundle.setDefaultParentBean(this.defaultParentView);
        for (int i = 0; i < beanFactory2.size(); ++i) {
            ResourceBundle resourceBundle2 = (ResourceBundle)beanFactory2.get(i);
            resourceBundle.registerBeanDefinitions(resourceBundle2);
        }
        genericWebApplicationContext.refresh();
        if (this.isCache()) {
            this.localeCache.put(locale, genericWebApplicationContext);
            this.bundleCache.put(beanFactory2, genericWebApplicationContext);
        }
        return genericWebApplicationContext;
    }

    protected ResourceBundle getBundle(String string, Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(string, locale, this.getBundleClassLoader());
    }

    public void destroy() throws BeansException {
        Iterator iterator = this.bundleCache.values().iterator();
        while (iterator.hasNext()) {
            ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)iterator.next();
            configurableApplicationContext.close();
        }
        this.localeCache.clear();
        this.bundleCache.clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

