/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.JdkVersion;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class RedirectView
extends AbstractUrlBasedView {
    public static final String DEFAULT_ENCODING_SCHEME = "UTF-8";
    private boolean contextRelative = false;
    private boolean http10Compatible = true;
    private String encodingScheme = "UTF-8";

    public RedirectView() {
    }

    public RedirectView(String string) {
        super(string);
    }

    public RedirectView(String string, boolean bl) {
        super(string);
        this.contextRelative = bl;
    }

    public RedirectView(String string, boolean bl, boolean bl2) {
        super(string);
        this.contextRelative = bl;
        this.http10Compatible = bl2;
    }

    public void setContextRelative(boolean bl) {
        this.contextRelative = bl;
    }

    public void setHttp10Compatible(boolean bl) {
        this.http10Compatible = bl;
    }

    public void setEncodingScheme(String string) {
        this.encodingScheme = string;
    }

    protected final void renderMergedOutputModel(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.contextRelative && this.getUrl().startsWith("/")) {
            stringBuffer.append(httpServletRequest.getContextPath());
        }
        stringBuffer.append(this.getUrl());
        this.appendQueryProperties(stringBuffer, map, this.encodingScheme);
        this.sendRedirect(httpServletRequest, httpServletResponse, stringBuffer.toString(), this.http10Compatible);
    }

    protected void appendQueryProperties(StringBuffer stringBuffer, Map map, String string) throws UnsupportedEncodingException {
        String string2 = null;
        int n = stringBuffer.toString().indexOf(35);
        if (n > -1) {
            string2 = stringBuffer.substring(n);
            stringBuffer.delete(n, stringBuffer.length());
        }
        boolean bl = this.getUrl().indexOf(63) < 0;
        Iterator iterator = this.queryProperties(map).entrySet().iterator();
        while (iterator.hasNext()) {
            if (bl) {
                stringBuffer.append('?');
                bl = false;
            } else {
                stringBuffer.append('&');
            }
            Map.Entry entry = iterator.next();
            String string3 = this.urlEncode(entry.getKey().toString(), string);
            String string4 = entry.getValue() != null ? this.urlEncode(entry.getValue().toString(), string) : "";
            stringBuffer.append(string3).append('=').append(string4);
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
    }

    protected String urlEncode(String string, String string2) throws UnsupportedEncodingException {
        if (JdkVersion.getMajorJavaVersion() < 1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Only JDK 1.3 URLEncoder available: using platform default encoding instead of the requested scheme '" + string2 + "'"));
            }
            return URLEncoder.encode(string);
        }
        return URLEncoder.encode(string, string2);
    }

    protected Map queryProperties(Map map) {
        return map;
    }

    protected void sendRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) throws IOException {
        if (bl) {
            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string));
        } else {
            httpServletResponse.setStatus(303);
            httpServletResponse.setHeader("Location", httpServletResponse.encodeRedirectURL(string));
        }
    }
}

