/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.util.WebUtils;

public class InternalResourceView
extends AbstractUrlBasedView {
    private boolean alwaysInclude = false;

    public InternalResourceView() {
    }

    public InternalResourceView(String string) {
        super(string);
    }

    public InternalResourceView(String string, boolean bl) {
        super(string);
        this.alwaysInclude = bl;
    }

    public void setAlwaysInclude(boolean bl) {
        this.alwaysInclude = bl;
    }

    protected void renderMergedOutputModel(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.exposeModelAsRequestAttributes(map, httpServletRequest);
        this.exposeHelpers(httpServletRequest);
        String string = this.prepareForRendering(httpServletRequest, httpServletResponse);
        RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(string);
        if (requestDispatcher == null) {
            throw new ServletException("Could not get RequestDispatcher for [" + this.getUrl() + "]: check that this file exists within your WAR");
        }
        if (this.useInclude(httpServletRequest, httpServletResponse)) {
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Included resource [" + this.getUrl() + "] in InternalResourceView '" + this.getBeanName() + "'"));
            }
        } else {
            this.exposeForwardRequestAttributes(httpServletRequest);
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Forwarded to resource [" + this.getUrl() + "] in InternalResourceView '" + this.getBeanName() + "'"));
            }
        }
    }

    protected void exposeHelpers(HttpServletRequest httpServletRequest) throws Exception {
    }

    protected String prepareForRendering(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        return this.getUrl();
    }

    protected boolean useInclude(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.alwaysInclude || WebUtils.isIncludeRequest((ServletRequest)httpServletRequest) || httpServletResponse.isCommitted();
    }

    protected void exposeForwardRequestAttributes(HttpServletRequest httpServletRequest) {
        WebUtils.exposeForwardRequestAttributes((HttpServletRequest)httpServletRequest);
    }
}

