/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.RequestToViewNameTranslator;
import org.springframework.web.util.UrlPathHelper;

public class DefaultRequestToViewNameTranslator
implements RequestToViewNameTranslator {
    private static final String SLASH = "/";
    private String prefix = "";
    private String suffix = "";
    private String separator = "/";
    private boolean stripLeadingSlash = true;
    private boolean stripExtension = true;
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    public void setPrefix(String string) {
        this.prefix = string == null ? "" : string;
    }

    public void setSuffix(String string) {
        this.suffix = string == null ? "" : string;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public void setStripLeadingSlash(boolean bl) {
        this.stripLeadingSlash = bl;
    }

    public void setStripExtension(boolean bl) {
        this.stripExtension = bl;
    }

    public void setAlwaysUseFullPath(boolean bl) {
        this.urlPathHelper.setAlwaysUseFullPath(bl);
    }

    public void setUrlDecode(boolean bl) {
        this.urlPathHelper.setUrlDecode(bl);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        Assert.notNull((Object)urlPathHelper);
        this.urlPathHelper = urlPathHelper;
    }

    public final String getViewName(HttpServletRequest httpServletRequest) {
        String string = this.urlPathHelper.getLookupPathForRequest(httpServletRequest);
        return this.prefix + this.transformPath(string) + this.suffix;
    }

    protected String transformPath(String string) {
        String string2 = string;
        if (this.stripLeadingSlash && string2.startsWith(SLASH)) {
            string2 = string2.substring(1);
        }
        if (this.stripExtension) {
            string2 = StringUtils.stripFilenameExtension((String)string2);
        }
        if (!SLASH.equals(this.separator)) {
            string2 = StringUtils.replace((String)string2, (String)SLASH, (String)this.separator);
        }
        return string2;
    }
}

