/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.RequestContext;

public abstract class AbstractView
extends WebApplicationObjectSupport
implements View,
BeanNameAware {
    public static final String DEFAULT_CONTENT_TYPE = "text/html;charset=ISO-8859-1";
    private String beanName;
    private String contentType = "text/html;charset=ISO-8859-1";
    private String requestContextAttribute;
    private final Map staticAttributes = new HashMap();

    public void setBeanName(String string) {
        this.beanName = string;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setRequestContextAttribute(String string) {
        this.requestContextAttribute = string;
    }

    public String getRequestContextAttribute() {
        return this.requestContextAttribute;
    }

    public void setAttributesCSV(String string) throws IllegalArgumentException {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf("=");
                if (n == -1) {
                    throw new IllegalArgumentException("Expected = in attributes CSV string '" + string + "'");
                }
                if (n >= string2.length() - 2) {
                    throw new IllegalArgumentException("At least 2 characters ([]) required in attributes CSV string '" + string + "'");
                }
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                string4 = string4.substring(1);
                string4 = string4.substring(0, string4.length() - 1);
                this.addStaticAttribute(string3, string4);
            }
        }
    }

    public void setAttributes(Properties properties) {
        CollectionUtils.mergePropertiesIntoMap((Properties)properties, (Map)this.staticAttributes);
    }

    public void setAttributesMap(Map map) {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                if (!(k instanceof String)) {
                    throw new IllegalArgumentException("Invalid attribute key [" + k + "]: only Strings allowed");
                }
                this.addStaticAttribute((String)k, entry.getValue());
            }
        }
    }

    public Map getAttributesMap() {
        return this.staticAttributes;
    }

    public void addStaticAttribute(String string, Object object) {
        this.staticAttributes.put(string, object);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Set static attribute with name '" + string + "' and value [" + object + "] on view with name '" + this.getBeanName() + "'"));
        }
    }

    public Map getStaticAttributes() {
        return Collections.unmodifiableMap(this.staticAttributes);
    }

    public void render(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering view with name '" + this.beanName + "' with model " + map + " and static attributes " + this.staticAttributes));
        }
        HashMap<String, RequestContext> hashMap = new HashMap<String, RequestContext>(this.staticAttributes.size() + (map != null ? map.size() : 0));
        hashMap.putAll(this.staticAttributes);
        if (map != null) {
            hashMap.putAll(map);
        }
        if (this.requestContextAttribute != null) {
            hashMap.put(this.requestContextAttribute, this.createRequestContext(httpServletRequest, hashMap));
        }
        this.renderMergedOutputModel(hashMap, httpServletRequest, httpServletResponse);
    }

    protected RequestContext createRequestContext(HttpServletRequest httpServletRequest, Map map) {
        return new RequestContext(httpServletRequest, map);
    }

    protected abstract void renderMergedOutputModel(Map var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;

    protected void exposeModelAsRequestAttributes(Map map, HttpServletRequest httpServletRequest) throws Exception {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Invalid key [" + entry.getKey() + "] in model Map: only Strings allowed as model keys");
            }
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v != null) {
                httpServletRequest.setAttribute(string, v);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added model object '" + string + "' of type [" + v.getClass().getName() + "] to request in view with name '" + this.getBeanName() + "'"));
                continue;
            }
            httpServletRequest.removeAttribute(string);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Removed model object '" + string + "' from request in view with name '" + this.getBeanName() + "'"));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        if (this.getBeanName() != null) {
            stringBuffer.append(": name '").append(this.getBeanName()).append("'");
        } else {
            stringBuffer.append(": unnamed");
        }
        return stringBuffer.toString();
    }
}

