/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public abstract class AbstractTemplateView
extends AbstractUrlBasedView {
    public static final String SPRING_MACRO_REQUEST_CONTEXT_ATTRIBUTE = "springMacroRequestContext";
    private static boolean responseGetContentTypeAvailable = ClassUtils.hasMethod((Class)(class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = AbstractTemplateView.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse), (String)"getContentType", (Class[])new Class[0]);
    private boolean exposeRequestAttributes = false;
    private boolean allowRequestOverride = false;
    private boolean exposeSessionAttributes = false;
    private boolean allowSessionOverride = false;
    private boolean exposeSpringMacroHelpers = false;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;

    public void setExposeRequestAttributes(boolean bl) {
        this.exposeRequestAttributes = bl;
    }

    public void setAllowRequestOverride(boolean bl) {
        this.allowRequestOverride = bl;
    }

    public void setExposeSessionAttributes(boolean bl) {
        this.exposeSessionAttributes = bl;
    }

    public void setAllowSessionOverride(boolean bl) {
        this.allowSessionOverride = bl;
    }

    public void setExposeSpringMacroHelpers(boolean bl) {
        this.exposeSpringMacroHelpers = bl;
    }

    protected final void renderMergedOutputModel(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        Object object2;
        Enumeration enumeration;
        if (this.exposeRequestAttributes) {
            enumeration = httpServletRequest.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                if (map.containsKey(object2) && !this.allowRequestOverride) {
                    throw new ServletException("Cannot expose request attribute '" + (String)object2 + "' because of an existing model object of the same name");
                }
                object = httpServletRequest.getAttribute((String)object2);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Exposing request attribute '" + (String)object2 + "' with value [" + object + "] to model"));
                }
                map.put(object2, object);
            }
        }
        if (this.exposeSessionAttributes && (enumeration = httpServletRequest.getSession(false)) != null) {
            object2 = enumeration.getAttributeNames();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (map.containsKey(object) && !this.allowSessionOverride) {
                    throw new ServletException("Cannot expose session attribute '" + (String)object + "' because of an existing model object of the same name");
                }
                Object object3 = enumeration.getAttribute((String)object);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Exposing session attribute '" + (String)object + "' with value [" + object3 + "] to model"));
                }
                map.put(object, object3);
            }
        }
        if (this.exposeSpringMacroHelpers) {
            if (map.containsKey(SPRING_MACRO_REQUEST_CONTEXT_ATTRIBUTE)) {
                throw new ServletException("Cannot expose bind macro helper 'springMacroRequestContext' because of an existing model object of the same name");
            }
            map.put(SPRING_MACRO_REQUEST_CONTEXT_ATTRIBUTE, new RequestContext(httpServletRequest, map));
        }
        this.applyContentType(httpServletResponse);
        this.renderMergedTemplateModel(map, httpServletRequest, httpServletResponse);
    }

    protected void applyContentType(HttpServletResponse httpServletResponse) {
        if (!responseGetContentTypeAvailable || httpServletResponse.getContentType() == null) {
            httpServletResponse.setContentType(this.getContentType());
        }
    }

    protected abstract void renderMergedTemplateModel(Map var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

