/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public abstract class AbstractCachingViewResolver
extends WebApplicationObjectSupport
implements ViewResolver {
    private boolean cache = true;
    private final Map viewCache = new HashMap();

    public void setCache(boolean bl) {
        this.cache = bl;
    }

    public boolean isCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View resolveViewName(String string, Locale locale) throws Exception {
        if (!this.isCache()) {
            this.logger.warn((Object)"View caching is SWITCHED OFF -- DEVELOPMENT SETTING ONLY: This can severely impair performance");
            return this.createView(string, locale);
        }
        Object object = this.getCacheKey(string, locale);
        Map map = this.viewCache;
        synchronized (map) {
            View view = (View)this.viewCache.get(object);
            if (view == null) {
                view = this.createView(string, locale);
                this.viewCache.put(object, view);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Cached view [" + object + "]"));
                }
            }
            return view;
        }
    }

    protected Object getCacheKey(String string, Locale locale) {
        return string + "_" + locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(String string, Locale locale) {
        if (!this.cache) {
            this.logger.warn((Object)"View caching is SWITCHED OFF -- removal not necessary");
        } else {
            Object object = this.getCacheKey(string, locale);
            Object var4_4 = null;
            Map map = this.viewCache;
            synchronized (map) {
                var4_4 = this.viewCache.remove(object);
            }
            if (var4_4 == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("No cached instance for view '" + object + "' was found"));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cache for view " + object + " has been cleared"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.logger.debug((Object)"Clearing entire view cache");
        Map map = this.viewCache;
        synchronized (map) {
            this.viewCache.clear();
        }
    }

    protected View createView(String string, Locale locale) throws Exception {
        return this.loadView(string, locale);
    }

    protected abstract View loadView(String var1, Locale var2) throws Exception;
}

