/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.theme;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.support.RequestContextUtils;

public class ThemeChangeInterceptor
extends HandlerInterceptorAdapter {
    public static final String DEFAULT_PARAM_NAME = "theme";
    private String paramName = "theme";

    public void setParamName(String string) {
        this.paramName = string;
    }

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws ServletException {
        ThemeResolver themeResolver = RequestContextUtils.getThemeResolver(httpServletRequest);
        if (themeResolver == null) {
            throw new IllegalStateException("No ThemeResolver found: not in a DispatcherServlet request?");
        }
        String string = httpServletRequest.getParameter(this.paramName);
        if (string != null) {
            themeResolver.setThemeName(httpServletRequest, httpServletResponse, string);
        }
        return true;
    }
}

