/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.theme;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.util.CookieGenerator;
import org.springframework.web.util.WebUtils;

public class CookieThemeResolver
extends CookieGenerator
implements ThemeResolver {
    public static final String ORIGINAL_DEFAULT_THEME_NAME = "theme";
    public static final String THEME_REQUEST_ATTRIBUTE_NAME = (class$org$springframework$web$servlet$theme$CookieThemeResolver == null ? (class$org$springframework$web$servlet$theme$CookieThemeResolver = CookieThemeResolver.class$("org.springframework.web.servlet.theme.CookieThemeResolver")) : class$org$springframework$web$servlet$theme$CookieThemeResolver).getName() + ".THEME";
    public static final String DEFAULT_COOKIE_NAME = (class$org$springframework$web$servlet$theme$CookieThemeResolver == null ? (class$org$springframework$web$servlet$theme$CookieThemeResolver = CookieThemeResolver.class$("org.springframework.web.servlet.theme.CookieThemeResolver")) : class$org$springframework$web$servlet$theme$CookieThemeResolver).getName() + ".THEME";
    private String defaultThemeName = "theme";
    static /* synthetic */ Class class$org$springframework$web$servlet$theme$CookieThemeResolver;

    public CookieThemeResolver() {
        this.setCookieName(DEFAULT_COOKIE_NAME);
    }

    public void setDefaultThemeName(String string) {
        this.defaultThemeName = string;
    }

    public String getDefaultThemeName() {
        return this.defaultThemeName;
    }

    public String resolveThemeName(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute(THEME_REQUEST_ATTRIBUTE_NAME);
        if (string != null) {
            return string;
        }
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)httpServletRequest, (String)this.getCookieName());
        if (cookie != null) {
            return cookie.getValue();
        }
        return this.getDefaultThemeName();
    }

    public void setThemeName(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        if (string != null) {
            httpServletRequest.setAttribute(THEME_REQUEST_ATTRIBUTE_NAME, (Object)string);
            this.addCookie(httpServletResponse, string);
        } else {
            httpServletRequest.setAttribute(THEME_REQUEST_ATTRIBUTE_NAME, (Object)this.getDefaultThemeName());
            this.removeCookie(httpServletResponse);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

