/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import javax.servlet.jsp.JspException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TagWriter {
    private final SafeWriter writer;
    private Stack tagState = new Stack();

    public TagWriter(Writer writer) {
        Assert.notNull((Object)writer, (String)"Writer must not be null");
        this.writer = new SafeWriter(writer);
    }

    public void startTag(String string) throws JspException {
        if (this.inTag()) {
            this.closeTagAndMarkAsBlock();
        }
        this.push(string);
        this.writer.append("<").append(string);
    }

    public void writeAttribute(String string, String string2) throws JspException {
        if (this.currentState().isBlockTag()) {
            throw new IllegalStateException("Cannot write attributes after opening tag is closed.");
        }
        this.writer.append(" ").append(string).append("=\"").append(string2).append("\"");
    }

    public void writeOptionalAttributeValue(String string, String string2) throws JspException {
        if (StringUtils.hasText((String)string2)) {
            this.writeAttribute(string, string2);
        }
    }

    public void appendValue(String string) throws JspException {
        if (!this.inTag()) {
            throw new IllegalStateException("Cannot write tag value. No open tag available.");
        }
        this.closeTagAndMarkAsBlock();
        this.writer.append(string);
    }

    public void forceBlock() throws JspException {
        if (this.currentState().isBlockTag()) {
            return;
        }
        this.closeTagAndMarkAsBlock();
    }

    public void endTag() throws JspException {
        this.endTag(false);
    }

    public void endTag(boolean bl) throws JspException {
        if (!this.inTag()) {
            throw new IllegalStateException("Cannot write end of tag. No open tag available.");
        }
        boolean bl2 = true;
        if (!this.currentState().isBlockTag()) {
            if (bl) {
                this.writer.append(">");
            } else {
                this.writer.append("/>");
                bl2 = false;
            }
        }
        if (bl2) {
            this.writer.append("</").append(this.currentState().getTagName()).append(">");
        }
        this.tagState.pop();
    }

    private void push(String string) {
        this.tagState.push(new TagStateEntry(string));
    }

    private void closeTagAndMarkAsBlock() throws JspException {
        if (!this.currentState().isBlockTag()) {
            this.currentState().markAsBlockTag();
            this.writer.append(">");
        }
    }

    private boolean inTag() {
        return this.tagState.size() > 0;
    }

    private TagStateEntry currentState() {
        return (TagStateEntry)this.tagState.peek();
    }

    private static final class SafeWriter {
        private final Writer writer;

        public SafeWriter(Writer writer) {
            this.writer = writer;
        }

        public SafeWriter append(String string) throws JspException {
            try {
                this.writer.write(String.valueOf(string));
                return this;
            }
            catch (IOException iOException) {
                throw new JspException("Unable to write to JspWriter", (Throwable)iOException);
            }
        }
    }

    private static final class TagStateEntry {
        private final String tagName;
        private boolean blockTag;

        public TagStateEntry(String string) {
            this.tagName = string;
        }

        public String getTagName() {
            return this.tagName;
        }

        public void markAsBlockTag() {
            this.blockTag = true;
        }

        public boolean isBlockTag() {
            return this.blockTag;
        }
    }
}

