/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.core.JdkVersion;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.support.BindStatus;

abstract class SelectedValueComparator {
    SelectedValueComparator() {
    }

    public static boolean isSelected(BindStatus bindStatus, Object object) {
        Object object2 = SelectedValueComparator.getBoundValue(bindStatus);
        if (object2 == null) {
            return object == null;
        }
        boolean bl = false;
        if (object2.getClass().isArray()) {
            bl = SelectedValueComparator.collectionCompare(CollectionUtils.arrayToList((Object)object2), object, bindStatus);
        } else if (object2 instanceof Collection) {
            bl = SelectedValueComparator.collectionCompare((Collection)object2, object, bindStatus);
        } else if (object2 instanceof Map) {
            bl = SelectedValueComparator.mapCompare((Map)object2, object, bindStatus);
        }
        if (!bl) {
            bl = ObjectUtils.nullSafeEquals((Object)object2, (Object)object) ? true : SelectedValueComparator.exhaustiveCompare(object2, object, bindStatus.getEditor());
        }
        return bl;
    }

    private static boolean mapCompare(Map map, Object object, BindStatus bindStatus) {
        if (map.containsKey(object)) {
            return true;
        }
        return SelectedValueComparator.exhaustiveCollectionCompare(map.keySet(), object, bindStatus);
    }

    private static boolean collectionCompare(Collection collection, Object object, BindStatus bindStatus) {
        if (collection.contains(object)) {
            return true;
        }
        return SelectedValueComparator.exhaustiveCollectionCompare(collection, object, bindStatus);
    }

    private static Object getBoundValue(BindStatus bindStatus) {
        Object object;
        if (bindStatus == null) {
            return null;
        }
        if (bindStatus.getEditor() != null && (object = bindStatus.getEditor().getValue()) != null) {
            return object;
        }
        return bindStatus.getValue();
    }

    private static boolean exhaustiveCollectionCompare(Collection collection, Object object, BindStatus bindStatus) {
        PropertyEditorRegistry propertyEditorRegistry = null;
        if (bindStatus.getErrors() instanceof BindingResult) {
            propertyEditorRegistry = ((BindingResult)bindStatus.getErrors()).getPropertyEditorRegistry();
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            PropertyEditor propertyEditor = null;
            if (e != null && propertyEditorRegistry != null) {
                propertyEditor = propertyEditorRegistry.findCustomEditor(e.getClass(), bindStatus.getPath());
            }
            if (!SelectedValueComparator.exhaustiveCompare(e, object, propertyEditor)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean exhaustiveCompare(Object object, Object object2, PropertyEditor propertyEditor) {
        String string = ObjectUtils.getDisplayString((Object)object2);
        if (object instanceof LabeledEnum) {
            LabeledEnum labeledEnum = (LabeledEnum)object;
            String string2 = ObjectUtils.getDisplayString((Object)labeledEnum.getCode());
            if (string2.equals(string)) {
                return true;
            }
            String string3 = ObjectUtils.getDisplayString((Object)labeledEnum.getLabel());
            if (string3.equals(string)) {
                return true;
            }
        } else if (JdkVersion.isAtLeastJava15() && object.getClass().isEnum()) {
            Enum enum_ = (Enum)object;
            String string4 = ObjectUtils.getDisplayString((Object)enum_.name());
            if (string4.equals(string)) {
                return true;
            }
            String string5 = ObjectUtils.getDisplayString((Object)enum_.toString());
            if (string5.equals(string)) {
                return true;
            }
        } else {
            if (ObjectUtils.getDisplayString((Object)object).equals(string)) {
                return true;
            }
            if (propertyEditor != null && object2 instanceof String) {
                Object object3 = propertyEditor.getValue();
                String string6 = (String)object2;
                try {
                    propertyEditor.setAsText(string6);
                    if (ObjectUtils.nullSafeEquals((Object)object, (Object)propertyEditor.getValue())) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    propertyEditor.setValue(object3);
                }
                if (propertyEditor.getValue() != null) {
                    return ObjectUtils.nullSafeEquals((Object)string6, (Object)propertyEditor.getAsText());
                }
            }
        }
        return false;
    }
}

