/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.JspException;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.SelectedValueComparator;
import org.springframework.web.servlet.tags.form.TagWriter;
import org.springframework.web.servlet.tags.form.ValueFormatter;

final class OptionWriter {
    private final ValueFormatter valueFormatter = new ValueFormatter();
    private final Object optionSource;
    private final BindStatus bindStatus;
    private final String valueProperty;
    private final String labelProperty;
    private final boolean htmlEscape;

    public OptionWriter(Object object, BindStatus bindStatus, String string, String string2, boolean bl) {
        Assert.notNull((Object)object, (String)"'optionSource' must not be null");
        Assert.notNull((Object)bindStatus, (String)"'bindStatus' must not be null");
        this.optionSource = object;
        this.bindStatus = bindStatus;
        this.valueProperty = string;
        this.labelProperty = string2;
        this.htmlEscape = bl;
    }

    public void writeOptions(TagWriter tagWriter) throws JspException {
        if (this.optionSource.getClass().isArray()) {
            this.renderFromArray(tagWriter);
        } else if (this.optionSource instanceof Collection) {
            this.renderFromCollection(tagWriter);
        } else if (this.optionSource instanceof Map) {
            this.renderFromMap(tagWriter);
        } else {
            throw new JspException("Type [" + this.optionSource.getClass().getName() + "] is not valid for option items");
        }
    }

    private void renderFromArray(TagWriter tagWriter) throws JspException {
        this.doRenderFromCollection(CollectionUtils.arrayToList((Object)this.optionSource), tagWriter);
    }

    private void renderFromMap(TagWriter tagWriter) throws JspException {
        Map map = (Map)this.optionSource;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.renderOption(tagWriter, entry, entry.getKey().toString(), entry.getValue().toString());
        }
    }

    private void renderFromCollection(TagWriter tagWriter) throws JspException {
        this.doRenderFromCollection((Collection)this.optionSource, tagWriter);
    }

    private void doRenderFromCollection(Collection collection, TagWriter tagWriter) throws JspException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(e);
            Object e2 = this.valueProperty != null ? beanWrapperImpl.getPropertyValue(this.valueProperty) : e;
            Object e3 = this.labelProperty != null ? beanWrapperImpl.getPropertyValue(this.labelProperty) : e;
            this.renderOption(tagWriter, e, e2, e3);
        }
    }

    private void renderOption(TagWriter tagWriter, Object object, Object object2, Object object3) throws JspException {
        tagWriter.startTag("option");
        String string = this.getDisplayString(object2);
        String string2 = this.getDisplayString(object3);
        tagWriter.writeAttribute("value", string);
        if (this.isSelected(object2) || this.isSelected(object)) {
            tagWriter.writeAttribute("selected", "selected");
        }
        tagWriter.appendValue(string2);
        tagWriter.endTag();
    }

    private boolean isSelected(Object object) {
        return SelectedValueComparator.isSelected(this.bindStatus, object);
    }

    private String getDisplayString(Object object) {
        return this.valueFormatter.getDisplayString(object, this.bindStatus.getEditor(), this.htmlEscape);
    }
}

