/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.AbstractHtmlElementBodyTag;
import org.springframework.web.servlet.tags.form.SelectedValueComparator;
import org.springframework.web.servlet.tags.form.TagWriter;
import org.springframework.web.util.TagUtils;

public class OptionTag
extends AbstractHtmlElementBodyTag
implements BodyTag {
    public static final String VALUE_VARIABLE_NAME = "value";
    public static final String DISPLAY_VALUE_VARIABLE_NAME = "displayValue";
    private static final String SELECTED_ATTRIBUTE = "selected";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String DISABLED_ATTRIBUTE = "disabled";
    private Object value;
    private String label;
    private Object oldValue;
    private Object oldDisplayValue;
    private String disabled;
    static /* synthetic */ Class class$org$springframework$web$servlet$tags$form$SelectTag;

    public void setValue(Object object) {
        this.value = object;
    }

    protected Object getValue() {
        return this.value;
    }

    public void setDisabled(String string) {
        this.disabled = string;
    }

    protected String getDisabled() {
        return this.disabled;
    }

    protected boolean isDisabled() {
        return "true".equals(this.getDisabled());
    }

    public void setLabel(String string) {
        Assert.notNull((Object)string, (String)"'label' must not be null");
        this.label = string;
    }

    protected String getLabel() {
        return this.label;
    }

    protected void renderDefaultContent(TagWriter tagWriter) throws JspException {
        Object object = this.pageContext.getAttribute("value");
        String string = this.getLabelValue(object);
        this.renderOption(object, string, tagWriter);
    }

    protected void renderFromBodyContent(BodyContent bodyContent, TagWriter tagWriter) throws JspException {
        Object object = this.pageContext.getAttribute("value");
        String string = bodyContent.getString();
        this.renderOption(object, string, tagWriter);
    }

    protected void onWriteTagContent() {
        this.assertUnderSelectTag();
    }

    protected void exposeAttributes() throws JspException {
        Object object = this.resolveValue();
        this.oldValue = this.pageContext.getAttribute("value");
        this.pageContext.setAttribute("value", object);
        this.oldDisplayValue = this.pageContext.getAttribute(DISPLAY_VALUE_VARIABLE_NAME);
        this.pageContext.setAttribute(DISPLAY_VALUE_VARIABLE_NAME, (Object)this.getDisplayString(object, this.getBindStatus().getEditor()));
    }

    protected BindStatus getBindStatus() {
        return (BindStatus)this.pageContext.getAttribute("org.springframework.web.servlet.tags.form.SelectTag.listValue");
    }

    protected void removeAttributes() {
        if (this.oldValue != null) {
            this.pageContext.setAttribute("value", this.oldValue);
            this.oldValue = null;
        } else {
            this.pageContext.removeAttribute("value");
        }
        if (this.oldDisplayValue != null) {
            this.pageContext.setAttribute(DISPLAY_VALUE_VARIABLE_NAME, this.oldDisplayValue);
            this.oldDisplayValue = null;
        } else {
            this.pageContext.removeAttribute(DISPLAY_VALUE_VARIABLE_NAME);
        }
    }

    private void renderOption(Object object, String string, TagWriter tagWriter) throws JspException {
        tagWriter.startTag("option");
        String string2 = this.getDisplayString(object, this.getBindStatus().getEditor());
        tagWriter.writeAttribute("value", string2);
        if (this.isSelected(object)) {
            tagWriter.writeAttribute(SELECTED_ATTRIBUTE, SELECTED_ATTRIBUTE);
        }
        if (this.isDisabled()) {
            tagWriter.writeAttribute(DISABLED_ATTRIBUTE, DISABLED_ATTRIBUTE);
        }
        tagWriter.appendValue(string);
        tagWriter.endTag();
    }

    private String getLabelValue(Object object) throws JspException {
        String string = this.getLabel();
        Object object2 = string == null ? object : this.evaluate("label", string);
        return this.getDisplayString(object2, this.getBindStatus().getEditor());
    }

    private void assertUnderSelectTag() {
        TagUtils.assertHasAncestorOfType((Tag)this, (Class)(class$org$springframework$web$servlet$tags$form$SelectTag == null ? (class$org$springframework$web$servlet$tags$form$SelectTag = OptionTag.class$("org.springframework.web.servlet.tags.form.SelectTag")) : class$org$springframework$web$servlet$tags$form$SelectTag), (String)"option", (String)"select");
    }

    private boolean isSelected(Object object) {
        return SelectedValueComparator.isSelected(this.getBindStatus(), object);
    }

    private Object resolveValue() throws JspException {
        return this.evaluate("value", this.getValue());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

