/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.tags.form.AbstractHtmlElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;
import org.springframework.web.util.HtmlUtils;

public class FormTag
extends AbstractHtmlElementTag {
    private static final String DEFAULT_METHOD = "post";
    public static final String DEFAULT_COMMAND_NAME = "command";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ONSUBMIT_ATTRIBUTE = "onsubmit";
    public static final String ONRESET_ATTRIBUTE = "onreset";
    public static final String METHOD_ATTRIBUTE = "method";
    public static final String ACTION_ATTRIBUTE = "action";
    public static final String ENCTYPE_ATTRIBUTE = "enctype";
    private TagWriter tagWriter;
    private String commandName = "command";
    private String name;
    private String action;
    private String method = "post";
    private String enctype;
    private String onsubmit;
    private String onreset;

    public void setCommandName(String string) {
        this.commandName = string;
    }

    protected String getCommandName() {
        return this.commandName;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setAction(String string) {
        this.action = string != null ? string : "";
    }

    protected String getAction() {
        return this.action;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    protected String getMethod() {
        return this.method;
    }

    public void setEnctype(String string) {
        this.enctype = string;
    }

    protected String getEnctype() {
        return this.enctype;
    }

    public void setOnsubmit(String string) {
        this.onsubmit = string;
    }

    protected String getOnsubmit() {
        return this.onsubmit;
    }

    public void setOnreset(String string) {
        this.onreset = string;
    }

    protected String getOnreset() {
        return this.onreset;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        this.tagWriter = tagWriter;
        this.tagWriter.startTag("form");
        this.writeDefaultAttributes(tagWriter);
        this.tagWriter.writeAttribute(METHOD_ATTRIBUTE, this.getDisplayString(this.evaluate(METHOD_ATTRIBUTE, this.getMethod())));
        this.tagWriter.writeAttribute(ACTION_ATTRIBUTE, this.resolveAction());
        this.writeOptionalAttribute(tagWriter, ENCTYPE_ATTRIBUTE, this.getEnctype());
        this.writeOptionalAttribute(tagWriter, ONSUBMIT_ATTRIBUTE, this.getOnsubmit());
        this.writeOptionalAttribute(tagWriter, ONRESET_ATTRIBUTE, this.getOnreset());
        this.tagWriter.forceBlock();
        this.pageContext.setAttribute(COMMAND_NAME_VARIABLE_NAME, (Object)this.resolveCommandName(), 2);
        return 1;
    }

    protected String getName() throws JspException {
        return this.name;
    }

    protected String autogenerateId() throws JspException {
        return this.resolveCommandName();
    }

    protected String resolveCommandName() throws JspException {
        Object object = this.evaluate("commandName", this.getCommandName());
        if (object == null) {
            throw new IllegalArgumentException("'commandName' must not be null");
        }
        return (String)object;
    }

    protected String resolveAction() throws JspException {
        String string = this.getAction();
        if (StringUtils.hasText((String)string)) {
            return this.getDisplayString(this.evaluate(ACTION_ATTRIBUTE, string));
        }
        String string2 = this.getRequestContext().getRequestUri();
        ServletResponse servletResponse = this.pageContext.getResponse();
        if (servletResponse instanceof HttpServletResponse) {
            string2 = ((HttpServletResponse)servletResponse).encodeURL(string2);
            String string3 = this.getRequestContext().getQueryString();
            if (StringUtils.hasText((String)string3)) {
                string2 = string2 + "?" + HtmlUtils.htmlEscape((String)string3);
            }
        }
        if (StringUtils.hasText((String)string2)) {
            return string2;
        }
        throw new IllegalArgumentException("Attribute 'action' is required. Attempted to resolve against current request URI but request URI was null");
    }

    public int doEndTag() throws JspException {
        this.tagWriter.endTag();
        this.pageContext.getRequest().removeAttribute(COMMAND_NAME_VARIABLE_NAME);
        return 6;
    }

    public void doFinally() {
        super.doFinally();
        this.tagWriter = null;
    }

    protected String resolveCssClass() throws JspException {
        return ObjectUtils.getDisplayString((Object)this.evaluate("class", this.getCssClass()));
    }

    public void setPath(String string) {
        throw new UnsupportedOperationException("The 'path' attribute is not supported for forms");
    }

    public void setCssErrorClass(String string) {
        throw new UnsupportedOperationException("The 'cssErrorClass' attribute is not supported for forms");
    }
}

