/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.util.Collection;
import javax.servlet.jsp.JspException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.tags.form.AbstractHtmlInputElementTag;
import org.springframework.web.servlet.tags.form.SelectedValueComparator;
import org.springframework.web.servlet.tags.form.TagIdGenerator;
import org.springframework.web.servlet.tags.form.TagWriter;

public class CheckboxTag
extends AbstractHtmlInputElementTag {
    private Object value;
    static /* synthetic */ Class class$java$lang$Boolean;

    public void setValue(Object object) {
        Assert.notNull((Object)object, (String)"'value' must not be null");
        this.value = object;
    }

    protected Object getValue() {
        return this.value;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag("input");
        this.writeDefaultAttributes(tagWriter);
        tagWriter.writeAttribute("type", "checkbox");
        Object object = this.getBoundValue();
        Class clazz = this.getBindStatus().getValueType();
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = CheckboxTag.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(clazz) || Boolean.TYPE.equals(clazz)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            Boolean bl = object != null ? (Boolean)object : Boolean.FALSE;
            this.renderFromBoolean(bl, tagWriter);
        } else {
            Object object2;
            Object object3 = this.getValue();
            if (object3 == null) {
                throw new IllegalArgumentException("Attribute 'value' is required when binding to non-boolean values");
            }
            Object object4 = object2 = object3 instanceof String ? this.evaluate("value", (String)object3) : object3;
            if (object != null && object.getClass().isArray()) {
                this.renderFromCollection(object2, CollectionUtils.arrayToList((Object)object), tagWriter);
            } else if (object instanceof Collection) {
                this.renderFromCollection(object2, (Collection)object, tagWriter);
            } else {
                this.renderSingleValue(object2, tagWriter);
            }
        }
        tagWriter.endTag();
        if (!this.isDisabled()) {
            tagWriter.startTag("input");
            tagWriter.writeAttribute("type", "hidden");
            tagWriter.writeAttribute("name", "_" + this.getName());
            tagWriter.writeAttribute("value", "on");
            tagWriter.endTag();
        }
        return 6;
    }

    private void renderSingleValue(Object object, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", this.getDisplayString(object));
        if (SelectedValueComparator.isSelected(this.getBindStatus(), object)) {
            tagWriter.writeAttribute("checked", "checked");
        }
    }

    private void renderFromCollection(Object object, Collection collection, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", this.getDisplayString(object));
        if (SelectedValueComparator.isSelected(this.getBindStatus(), object)) {
            tagWriter.writeAttribute("checked", "checked");
        }
    }

    private void renderFromBoolean(Boolean bl, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", "true");
        if (bl.booleanValue()) {
            tagWriter.writeAttribute("checked", "checked");
        }
    }

    protected String autogenerateId() throws JspException {
        return TagIdGenerator.nextId(this.getName(), this.pageContext);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

