/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.beans.PropertyEditor;
import javax.servlet.jsp.JspException;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.AbstractFormTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public abstract class AbstractDataBoundFormElementTag
extends AbstractFormTag {
    public static final String ID_ATTRIBUTE = "id";
    public static final String COMMAND_NAME_ATTRIBUTE = "commandName";
    public static final String COMMAND_NAME_VARIABLE_NAME = Conventions.getQualifiedAttributeName((Class)(class$org$springframework$web$servlet$tags$form$AbstractFormTag == null ? (class$org$springframework$web$servlet$tags$form$AbstractFormTag = AbstractDataBoundFormElementTag.class$("org.springframework.web.servlet.tags.form.AbstractFormTag")) : class$org$springframework$web$servlet$tags$form$AbstractFormTag), (String)"commandName");
    private String path;
    private String id;
    private BindStatus bindStatus;
    static /* synthetic */ Class class$org$springframework$web$servlet$tags$form$AbstractFormTag;

    public void setPath(String string) {
        Assert.hasText((String)string, (String)"'path' must not be empty");
        this.path = string;
    }

    protected final String getPath() throws JspException {
        return (String)this.evaluate("path", this.path);
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    protected void writeDefaultAttributes(TagWriter tagWriter) throws JspException {
        String string = this.getId();
        if (StringUtils.hasText((String)string)) {
            tagWriter.writeAttribute(ID_ATTRIBUTE, ObjectUtils.getDisplayString((Object)this.evaluate(ID_ATTRIBUTE, string)));
        } else {
            this.writeOptionalAttribute(tagWriter, ID_ATTRIBUTE, this.autogenerateId());
        }
        this.writeOptionalAttribute(tagWriter, "name", this.getName());
    }

    protected String autogenerateId() throws JspException {
        return this.getName();
    }

    protected String getName() throws JspException {
        return this.getCompletePath();
    }

    protected final Object getBoundValue() throws JspException {
        return this.getBindStatus().getValue();
    }

    protected PropertyEditor getPropertyEditor() throws JspException {
        return this.getBindStatus().getEditor();
    }

    protected BindStatus getBindStatus() throws JspException {
        if (this.bindStatus == null) {
            String string = this.getPath();
            String string2 = this.getBindPath(string);
            this.bindStatus = new BindStatus(this.getRequestContext(), string2, false);
        }
        return this.bindStatus;
    }

    private String getBindPath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.addBindPathElement(stringBuffer, this.getCommandName());
        this.addBindPathElement(stringBuffer, this.getNestedPath());
        this.addBindPathElement(stringBuffer, string);
        return stringBuffer.toString();
    }

    private void addBindPathElement(StringBuffer stringBuffer, String string) {
        if (StringUtils.hasLength((String)string)) {
            int n = stringBuffer.length();
            if (n > 0 && stringBuffer.charAt(n - 1) != '.') {
                stringBuffer.append('.');
            }
            stringBuffer.append(string);
        }
    }

    protected String getNestedPath() {
        return (String)this.pageContext.getAttribute("nestedPath", 2);
    }

    protected String getCompletePath() throws JspException {
        String string = this.getNestedPath();
        return string != null ? string + this.getPath() : this.getPath();
    }

    private String getCommandName() {
        return (String)this.pageContext.getAttribute(COMMAND_NAME_VARIABLE_NAME, 2);
    }

    public void doFinally() {
        super.doFinally();
        this.bindStatus = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

