/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.tags.HtmlEscapingAwareTag;
import org.springframework.web.util.ExpressionEvaluationUtils;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.JavaScriptUtils;
import org.springframework.web.util.TagUtils;

public class MessageTag
extends HtmlEscapingAwareTag {
    public static final String DEFAULT_ARGUMENT_SEPARATOR = ",";
    private Object message;
    private String code;
    private Object arguments;
    private String argumentSeparator = ",";
    private String text;
    private String var;
    private String scope = "page";
    private boolean javaScriptEscape = false;
    static /* synthetic */ Class class$org$springframework$context$MessageSourceResolvable;

    public void setMessage(Object object) {
        this.message = object;
    }

    public void setCode(String string) {
        this.code = string;
    }

    public void setArguments(Object object) {
        this.arguments = object;
    }

    public void setArgumentSeparator(String string) {
        this.argumentSeparator = string;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setVar(String string) {
        this.var = string;
    }

    public void setScope(String string) {
        this.scope = string;
    }

    public void setJavaScriptEscape(String string) throws JspException {
        this.javaScriptEscape = ExpressionEvaluationUtils.evaluateBoolean((String)"javaScriptEscape", (String)string, (PageContext)this.pageContext);
    }

    protected final int doStartTagInternal() throws JspException, IOException {
        try {
            String string = this.resolveMessage();
            string = this.isHtmlEscape() ? HtmlUtils.htmlEscape((String)string) : string;
            string = this.javaScriptEscape ? JavaScriptUtils.javaScriptEscape((String)string) : string;
            String string2 = ExpressionEvaluationUtils.evaluateString((String)"var", (String)this.var, (PageContext)this.pageContext);
            if (string2 != null) {
                String string3 = ExpressionEvaluationUtils.evaluateString((String)"scope", (String)this.scope, (PageContext)this.pageContext);
                this.pageContext.setAttribute(string2, (Object)string, TagUtils.getScope((String)string3));
            } else {
                this.writeMessage(string);
            }
            return 1;
        }
        catch (NoSuchMessageException noSuchMessageException) {
            throw new JspTagException(this.getNoSuchMessageExceptionDescription(noSuchMessageException));
        }
    }

    protected String resolveMessage() throws JspException, NoSuchMessageException {
        String string;
        MessageSource messageSource = this.getMessageSource();
        if (messageSource == null) {
            throw new JspTagException("No corresponding MessageSource found");
        }
        MessageSourceResolvable messageSourceResolvable = null;
        if (this.message instanceof MessageSourceResolvable) {
            messageSourceResolvable = (MessageSourceResolvable)this.message;
        } else if (this.message != null) {
            string = this.message.toString();
            messageSourceResolvable = (MessageSourceResolvable)ExpressionEvaluationUtils.evaluate((String)"message", (String)string, (Class)(class$org$springframework$context$MessageSourceResolvable == null ? (class$org$springframework$context$MessageSourceResolvable = MessageTag.class$("org.springframework.context.MessageSourceResolvable")) : class$org$springframework$context$MessageSourceResolvable), (PageContext)this.pageContext);
        }
        if (messageSourceResolvable != null) {
            return messageSource.getMessage(messageSourceResolvable, this.getRequestContext().getLocale());
        }
        string = ExpressionEvaluationUtils.evaluateString((String)"code", (String)this.code, (PageContext)this.pageContext);
        String string2 = ExpressionEvaluationUtils.evaluateString((String)"text", (String)this.text, (PageContext)this.pageContext);
        if (string != null) {
            Object[] objectArray = this.resolveArguments(this.arguments);
            if (string2 != null) {
                return messageSource.getMessage(string, objectArray, string2, this.getRequestContext().getLocale());
            }
            return messageSource.getMessage(string, objectArray, this.getRequestContext().getLocale());
        }
        return string2;
    }

    protected Object[] resolveArguments(Object object) throws JspException {
        if (object instanceof String) {
            String[] stringArray = StringUtils.delimitedListToStringArray((String)((String)object), (String)this.argumentSeparator);
            if (stringArray.length == 1) {
                Object object2 = ExpressionEvaluationUtils.evaluate((String)"argument", (String)stringArray[0], (PageContext)this.pageContext);
                if (object2 != null && object2.getClass().isArray()) {
                    return ObjectUtils.toObjectArray((Object)object2);
                }
                return new Object[]{object2};
            }
            Object[] objectArray = new Object[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                objectArray[i] = ExpressionEvaluationUtils.evaluate((String)("argument[" + i + "]"), (String)stringArray[i], (PageContext)this.pageContext);
            }
            return objectArray;
        }
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        if (object instanceof Collection) {
            return ((Collection)object).toArray();
        }
        if (object != null) {
            return new Object[]{object};
        }
        return null;
    }

    protected void writeMessage(String string) throws IOException {
        this.pageContext.getOut().write(String.valueOf(string));
    }

    protected MessageSource getMessageSource() {
        return this.getRequestContext().getWebApplicationContext();
    }

    protected String getNoSuchMessageExceptionDescription(NoSuchMessageException noSuchMessageException) {
        return noSuchMessageException.getMessage();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

