/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import org.springframework.web.servlet.tags.HtmlEscapingAwareTag;
import org.springframework.web.util.ExpressionEvaluationUtils;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.JavaScriptUtils;

public class EscapeBodyTag
extends HtmlEscapingAwareTag
implements BodyTag {
    private boolean javaScriptEscape = false;
    private BodyContent bodyContent;

    public void setJavaScriptEscape(String string) throws JspException {
        this.javaScriptEscape = ExpressionEvaluationUtils.evaluateBoolean((String)"javaScriptEscape", (String)string, (PageContext)this.pageContext);
    }

    protected int doStartTagInternal() {
        return 2;
    }

    public void doInitBody() {
    }

    public void setBodyContent(BodyContent bodyContent) {
        this.bodyContent = bodyContent;
    }

    public int doAfterBody() throws JspException {
        try {
            String string = this.readBodyContent();
            string = this.isHtmlEscape() ? HtmlUtils.htmlEscape((String)string) : string;
            string = this.javaScriptEscape ? JavaScriptUtils.javaScriptEscape((String)string) : string;
            this.writeBodyContent(string);
        }
        catch (IOException iOException) {
            throw new JspException("Could not write escaped body", (Throwable)iOException);
        }
        return 0;
    }

    protected String readBodyContent() throws IOException {
        return this.bodyContent.getString();
    }

    protected void writeBodyContent(String string) throws IOException {
        this.bodyContent.getEnclosingWriter().print(string);
    }
}

