/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.context.support.WebApplicationObjectSupport;

public abstract class WebContentGenerator
extends WebApplicationObjectSupport {
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    private static final String HEADER_PRAGMA = "Pragma";
    private static final String HEADER_EXPIRES = "Expires";
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private Set supportedMethods = new HashSet();
    private boolean requireSession = false;
    private boolean useExpiresHeader = true;
    private boolean useCacheControlHeader = true;
    private int cacheSeconds = -1;

    public WebContentGenerator() {
        this.supportedMethods.add(METHOD_HEAD);
        this.supportedMethods.add(METHOD_GET);
        this.supportedMethods.add(METHOD_POST);
    }

    public final void setSupportedMethods(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("supportedMethods must not be empty");
        }
        this.supportedMethods.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            this.supportedMethods.add(stringArray[i]);
        }
    }

    public final String[] getSupportedMethods() {
        return StringUtils.toStringArray((Collection)this.supportedMethods);
    }

    public final void setRequireSession(boolean bl) {
        this.requireSession = bl;
    }

    public final boolean isRequireSession() {
        return this.requireSession;
    }

    public final void setUseExpiresHeader(boolean bl) {
        this.useExpiresHeader = bl;
    }

    public final boolean isUseExpiresHeader() {
        return this.useExpiresHeader;
    }

    public final void setUseCacheControlHeader(boolean bl) {
        this.useCacheControlHeader = bl;
    }

    public final boolean isUseCacheControlHeader() {
        return this.useCacheControlHeader;
    }

    public final void setCacheSeconds(int n) {
        this.cacheSeconds = n;
    }

    public final int getCacheSeconds() {
        return this.cacheSeconds;
    }

    protected final void checkAndPrepare(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws ServletException {
        this.checkAndPrepare(httpServletRequest, httpServletResponse, this.cacheSeconds, bl);
    }

    protected final void checkAndPrepare(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, boolean bl) throws ServletException {
        String string = httpServletRequest.getMethod();
        if (!this.supportedMethods.contains(string)) {
            throw new HttpRequestMethodNotSupportedException(string);
        }
        if (this.requireSession && httpServletRequest.getSession(false) == null) {
            throw new HttpSessionRequiredException("Pre-existing session required but none found");
        }
        this.applyCacheSeconds(httpServletResponse, n, bl);
    }

    protected final void preventCaching(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader(HEADER_PRAGMA, "No-cache");
        if (this.useExpiresHeader) {
            httpServletResponse.setDateHeader(HEADER_EXPIRES, 1L);
        }
        if (this.useCacheControlHeader) {
            httpServletResponse.setHeader(HEADER_CACHE_CONTROL, "no-cache");
            httpServletResponse.addHeader(HEADER_CACHE_CONTROL, "no-store");
        }
    }

    protected final void cacheForSeconds(HttpServletResponse httpServletResponse, int n) {
        this.cacheForSeconds(httpServletResponse, n, false);
    }

    protected final void cacheForSeconds(HttpServletResponse httpServletResponse, int n, boolean bl) {
        if (this.useExpiresHeader) {
            httpServletResponse.setDateHeader(HEADER_EXPIRES, System.currentTimeMillis() + (long)n * 1000L);
        }
        if (this.useCacheControlHeader) {
            String string = "max-age=" + n;
            if (bl) {
                string = string + ", must-revalidate";
            }
            httpServletResponse.setHeader(HEADER_CACHE_CONTROL, string);
        }
    }

    protected final void applyCacheSeconds(HttpServletResponse httpServletResponse, int n) {
        this.applyCacheSeconds(httpServletResponse, n, false);
    }

    protected final void applyCacheSeconds(HttpServletResponse httpServletResponse, int n, boolean bl) {
        if (n > 0) {
            this.cacheForSeconds(httpServletResponse, n, bl);
        } else if (n == 0) {
            this.preventCaching(httpServletResponse);
        }
    }
}

