/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ThemeResolver;

public abstract class RequestContextUtils {
    public static WebApplicationContext getWebApplicationContext(ServletRequest servletRequest) throws IllegalStateException {
        return RequestContextUtils.getWebApplicationContext(servletRequest, null);
    }

    public static WebApplicationContext getWebApplicationContext(ServletRequest servletRequest, ServletContext servletContext) throws IllegalStateException {
        WebApplicationContext webApplicationContext = (WebApplicationContext)servletRequest.getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (webApplicationContext == null) {
            if (servletContext == null) {
                throw new IllegalStateException("No WebApplicationContext found: not in a DispatcherServlet request?");
            }
            webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
            if (webApplicationContext == null) {
                throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
            }
        }
        return webApplicationContext;
    }

    public static LocaleResolver getLocaleResolver(HttpServletRequest httpServletRequest) {
        return (LocaleResolver)httpServletRequest.getAttribute(DispatcherServlet.LOCALE_RESOLVER_ATTRIBUTE);
    }

    public static Locale getLocale(HttpServletRequest httpServletRequest) {
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver(httpServletRequest);
        if (localeResolver != null) {
            return localeResolver.resolveLocale(httpServletRequest);
        }
        return httpServletRequest.getLocale();
    }

    public static ThemeResolver getThemeResolver(HttpServletRequest httpServletRequest) {
        return (ThemeResolver)httpServletRequest.getAttribute(DispatcherServlet.THEME_RESOLVER_ATTRIBUTE);
    }

    public static ThemeSource getThemeSource(HttpServletRequest httpServletRequest) {
        return (ThemeSource)httpServletRequest.getAttribute(DispatcherServlet.THEME_SOURCE_ATTRIBUTE);
    }

    public static Theme getTheme(HttpServletRequest httpServletRequest) {
        ThemeResolver themeResolver = RequestContextUtils.getThemeResolver(httpServletRequest);
        ThemeSource themeSource = RequestContextUtils.getThemeSource(httpServletRequest);
        if (themeResolver != null && themeSource != null) {
            String string = themeResolver.resolveThemeName(httpServletRequest);
            return themeSource.getTheme(string);
        }
        return null;
    }
}

