/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.ResourceBundleThemeSource;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.EscapedErrors;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public class RequestContext {
    public static final String DEFAULT_THEME_NAME = "theme";
    public static final String JSTL_LOCALE_ATTRIBUTE = "javax.servlet.jsp.jstl.fmt.locale";
    protected static final String REQUEST_SCOPE_SUFFIX = ".request";
    protected static final String SESSION_SCOPE_SUFFIX = ".session";
    protected static final String APPLICATION_SCOPE_SUFFIX = ".application";
    private HttpServletRequest request;
    private Map model;
    private WebApplicationContext webApplicationContext;
    private Locale locale;
    private Theme theme;
    private boolean defaultHtmlEscape;
    private UrlPathHelper urlPathHelper;
    private Map errorsMap;

    public RequestContext(HttpServletRequest httpServletRequest) {
        this.initContext(httpServletRequest, null, null);
    }

    public RequestContext(HttpServletRequest httpServletRequest, ServletContext servletContext) {
        this.initContext(httpServletRequest, servletContext, null);
    }

    public RequestContext(HttpServletRequest httpServletRequest, Map map) {
        this.initContext(httpServletRequest, null, map);
    }

    public RequestContext(HttpServletRequest httpServletRequest, ServletContext servletContext, Map map) {
        this.initContext(httpServletRequest, servletContext, map);
    }

    protected RequestContext() {
    }

    protected void initContext(HttpServletRequest httpServletRequest, ServletContext servletContext, Map map) {
        this.request = httpServletRequest;
        this.model = map;
        this.webApplicationContext = RequestContextUtils.getWebApplicationContext((ServletRequest)httpServletRequest, servletContext);
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver(httpServletRequest);
        this.locale = localeResolver != null ? localeResolver.resolveLocale(httpServletRequest) : this.getFallbackLocale();
        this.theme = RequestContextUtils.getTheme(httpServletRequest);
        if (this.theme == null) {
            this.theme = this.getFallbackTheme();
        }
        this.defaultHtmlEscape = WebUtils.isDefaultHtmlEscape((ServletContext)this.webApplicationContext.getServletContext());
        this.urlPathHelper = new UrlPathHelper();
    }

    protected Locale getFallbackLocale() {
        Locale locale = (Locale)this.getRequest().getAttribute(JSTL_LOCALE_ATTRIBUTE);
        if (locale == null && (locale = (Locale)this.getRequest().getAttribute("javax.servlet.jsp.jstl.fmt.locale.request")) == null) {
            HttpSession httpSession = this.getRequest().getSession(false);
            if (httpSession != null && (locale = (Locale)httpSession.getAttribute(JSTL_LOCALE_ATTRIBUTE)) == null) {
                locale = (Locale)httpSession.getAttribute("javax.servlet.jsp.jstl.fmt.locale.session");
            }
            if (locale == null && (locale = (Locale)this.getServletContext().getAttribute(JSTL_LOCALE_ATTRIBUTE)) == null && (locale = (Locale)this.getServletContext().getAttribute("javax.servlet.jsp.jstl.fmt.locale.application")) == null) {
                locale = this.getRequest().getLocale();
            }
        }
        return locale;
    }

    protected Theme getFallbackTheme() {
        ThemeSource themeSource = RequestContextUtils.getThemeSource(this.getRequest());
        if (themeSource == null) {
            themeSource = new ResourceBundleThemeSource();
        }
        return themeSource.getTheme(DEFAULT_THEME_NAME);
    }

    protected final HttpServletRequest getRequest() {
        return this.request;
    }

    public final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    protected final ServletContext getServletContext() {
        return this.webApplicationContext.getServletContext();
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final Theme getTheme() {
        return this.theme;
    }

    public void setDefaultHtmlEscape(boolean bl) {
        this.defaultHtmlEscape = bl;
    }

    public boolean isDefaultHtmlEscape() {
        return this.defaultHtmlEscape;
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper != null ? urlPathHelper : new UrlPathHelper();
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    public String getContextPath() {
        return this.urlPathHelper.getOriginatingContextPath(this.request);
    }

    public String getRequestUri() {
        return this.urlPathHelper.getOriginatingRequestUri(this.request);
    }

    public String getQueryString() {
        return this.urlPathHelper.getOriginatingQueryString(this.request);
    }

    public String getMessage(String string, String string2) {
        return this.getMessage(string, null, string2, this.defaultHtmlEscape);
    }

    public String getMessage(String string, Object[] objectArray, String string2) {
        return this.getMessage(string, objectArray, string2, this.defaultHtmlEscape);
    }

    public String getMessage(String string, List list, String string2) {
        return this.getMessage(string, list != null ? list.toArray() : null, string2, this.defaultHtmlEscape);
    }

    public String getMessage(String string, Object[] objectArray, String string2, boolean bl) {
        String string3 = this.webApplicationContext.getMessage(string, objectArray, string2, this.locale);
        return bl ? HtmlUtils.htmlEscape((String)string3) : string3;
    }

    public String getMessage(String string) throws NoSuchMessageException {
        return this.getMessage(string, null, this.defaultHtmlEscape);
    }

    public String getMessage(String string, Object[] objectArray) throws NoSuchMessageException {
        return this.getMessage(string, objectArray, this.defaultHtmlEscape);
    }

    public String getMessage(String string, List list) throws NoSuchMessageException {
        return this.getMessage(string, list != null ? list.toArray() : null, this.defaultHtmlEscape);
    }

    public String getMessage(String string, Object[] objectArray, boolean bl) throws NoSuchMessageException {
        String string2 = this.webApplicationContext.getMessage(string, objectArray, this.locale);
        return bl ? HtmlUtils.htmlEscape((String)string2) : string2;
    }

    public String getMessage(MessageSourceResolvable messageSourceResolvable) throws NoSuchMessageException {
        return this.getMessage(messageSourceResolvable, this.defaultHtmlEscape);
    }

    public String getMessage(MessageSourceResolvable messageSourceResolvable, boolean bl) throws NoSuchMessageException {
        String string = this.webApplicationContext.getMessage(messageSourceResolvable, this.locale);
        return bl ? HtmlUtils.htmlEscape((String)string) : string;
    }

    public String getThemeMessage(String string, String string2) {
        return this.theme.getMessageSource().getMessage(string, null, string2, this.locale);
    }

    public String getThemeMessage(String string, Object[] objectArray, String string2) {
        return this.theme.getMessageSource().getMessage(string, objectArray, string2, this.locale);
    }

    public String getThemeMessage(String string, List list, String string2) {
        return this.theme.getMessageSource().getMessage(string, list != null ? list.toArray() : null, string2, this.locale);
    }

    public String getThemeMessage(String string) throws NoSuchMessageException {
        return this.theme.getMessageSource().getMessage(string, null, this.locale);
    }

    public String getThemeMessage(String string, Object[] objectArray) throws NoSuchMessageException {
        return this.theme.getMessageSource().getMessage(string, objectArray, this.locale);
    }

    public String getThemeMessage(String string, List list) throws NoSuchMessageException {
        return this.theme.getMessageSource().getMessage(string, list != null ? list.toArray() : null, this.locale);
    }

    public String getThemeMessage(MessageSourceResolvable messageSourceResolvable) throws NoSuchMessageException {
        return this.theme.getMessageSource().getMessage(messageSourceResolvable, this.locale);
    }

    public Errors getErrors(String string) {
        return this.getErrors(string, this.defaultHtmlEscape);
    }

    public Errors getErrors(String string, boolean bl) {
        if (this.errorsMap == null) {
            this.errorsMap = new HashMap();
        }
        Errors errors = (Errors)this.errorsMap.get(string);
        boolean bl2 = false;
        if (errors == null) {
            errors = (Errors)this.getModelObject(BindingResult.MODEL_KEY_PREFIX + string);
            if (errors == null) {
                errors = (Errors)this.getModelObject(BindException.ERROR_KEY_PREFIX + string);
            }
            if (errors == null) {
                return null;
            }
            bl2 = true;
        }
        if (bl && !(errors instanceof EscapedErrors)) {
            errors = new EscapedErrors(errors);
            bl2 = true;
        } else if (!bl && errors instanceof EscapedErrors) {
            errors = ((EscapedErrors)errors).getSource();
            bl2 = true;
        }
        if (bl2) {
            this.errorsMap.put(string, errors);
        }
        return errors;
    }

    protected Object getModelObject(String string) {
        if (this.model != null) {
            return this.model.get(string);
        }
        return this.request.getAttribute(string);
    }

    public BindStatus getBindStatus(String string) throws IllegalStateException {
        return new BindStatus(this, string, this.defaultHtmlEscape);
    }

    public BindStatus getBindStatus(String string, boolean bl) throws IllegalStateException {
        return new BindStatus(this, string, bl);
    }
}

