/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceResourceBundle;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.servlet.support.RequestContextUtils;

public abstract class JstlUtils {
    public static final String REQUEST_SCOPE_SUFFIX = ".request";

    public static MessageSource getJstlAwareMessageSource(ServletContext servletContext, MessageSource messageSource) {
        String string = servletContext.getInitParameter("javax.servlet.jsp.jstl.fmt.localizationContext");
        if (string != null) {
            ResourceBundleMessageSource resourceBundleMessageSource = new ResourceBundleMessageSource();
            resourceBundleMessageSource.setBasename(string);
            resourceBundleMessageSource.setParentMessageSource(messageSource);
            return resourceBundleMessageSource;
        }
        return messageSource;
    }

    public static void exposeLocalizationContext(HttpServletRequest httpServletRequest, MessageSource messageSource) {
        Locale locale = RequestContextUtils.getLocale(httpServletRequest);
        MessageSourceResourceBundle messageSourceResourceBundle = new MessageSourceResourceBundle(messageSource, locale);
        LocalizationContext localizationContext = new LocalizationContext((ResourceBundle)messageSourceResourceBundle, locale);
        httpServletRequest.setAttribute("javax.servlet.jsp.jstl.fmt.localizationContext", (Object)localizationContext);
        httpServletRequest.setAttribute("javax.servlet.jsp.jstl.fmt.locale", (Object)locale);
        httpServletRequest.setAttribute("javax.servlet.jsp.jstl.fmt.localizationContext.request", (Object)localizationContext);
        httpServletRequest.setAttribute("javax.servlet.jsp.jstl.fmt.locale.request", (Object)locale);
    }
}

