/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.springframework.web.servlet.support.RequestContext;

public class JspAwareRequestContext
extends RequestContext {
    protected static final String PAGE_SCOPE_SUFFIX = ".page";
    private PageContext pageContext;

    public JspAwareRequestContext(PageContext pageContext) {
        this.initContext(pageContext, null);
    }

    public JspAwareRequestContext(PageContext pageContext, Map map) {
        this.initContext(pageContext, map);
    }

    protected void initContext(PageContext pageContext, Map map) {
        if (!(pageContext.getRequest() instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("RequestContext only supports HTTP requests");
        }
        this.pageContext = pageContext;
        this.initContext((HttpServletRequest)pageContext.getRequest(), pageContext.getServletContext(), map);
    }

    protected PageContext getPageContext() {
        return this.pageContext;
    }

    protected Locale getFallbackLocale() {
        Locale locale = (Locale)this.getPageContext().getAttribute("javax.servlet.jsp.jstl.fmt.locale");
        if (locale == null && (locale = (Locale)this.getPageContext().getAttribute("javax.servlet.jsp.jstl.fmt.locale.page")) == null) {
            locale = super.getFallbackLocale();
        }
        return locale;
    }
}

