/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.beans.PropertyEditor;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.StringUtils;
import org.springframework.validation.AbstractPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.util.HtmlUtils;

public class BindStatus {
    private final RequestContext requestContext;
    private final String path;
    private final boolean htmlEscape;
    private final String expression;
    private final Errors errors;
    private Object value;
    private Class valueType;
    private PropertyEditor editor;
    private List objectErrors;
    private String[] errorCodes;
    private String[] errorMessages;

    public BindStatus(RequestContext requestContext, String string, boolean bl) throws IllegalStateException {
        this.requestContext = requestContext;
        this.path = string;
        this.htmlEscape = bl;
        String string2 = null;
        int n = string.indexOf(46);
        if (n == -1) {
            string2 = string;
            this.expression = null;
        } else {
            string2 = string.substring(0, n);
            this.expression = string.substring(n + 1);
        }
        this.errors = requestContext.getErrors(string2, false);
        if (this.errors != null) {
            if (this.expression != null) {
                if ("*".equals(this.expression)) {
                    this.objectErrors = this.errors.getAllErrors();
                } else if (this.expression.endsWith("*")) {
                    this.objectErrors = this.errors.getFieldErrors(this.expression);
                } else {
                    this.objectErrors = this.errors.getFieldErrors(this.expression);
                    this.value = this.errors.getFieldValue(this.expression);
                    this.valueType = this.errors.getFieldType(this.expression);
                    this.editor = this.getCustomEditor(this.errors, this.expression);
                }
            } else {
                this.objectErrors = this.errors.getGlobalErrors();
            }
            this.initErrorCodes();
        } else {
            Object object = requestContext.getModelObject(string2);
            if (object == null) {
                throw new IllegalStateException("Neither BindingResult nor plain target object for bean name '" + string2 + "' available as request attribute");
            }
            if (this.expression != null && !"*".equals(this.expression) && !this.expression.endsWith("*")) {
                BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(object);
                this.valueType = beanWrapperImpl.getPropertyType(this.expression);
                this.value = beanWrapperImpl.getPropertyValue(this.expression);
            }
            this.errorCodes = new String[0];
            this.errorMessages = new String[0];
        }
        if (bl && this.value instanceof String) {
            this.value = HtmlUtils.htmlEscape((String)((String)this.value));
        }
    }

    private PropertyEditor getCustomEditor(Errors errors, String string) {
        Errors errors2 = errors;
        if (errors instanceof BindException) {
            errors2 = ((BindException)errors).getBindingResult();
        }
        if (errors2 instanceof AbstractPropertyBindingResult) {
            return ((AbstractPropertyBindingResult)errors2).getCustomEditor(string);
        }
        return null;
    }

    private void initErrorCodes() {
        this.errorCodes = new String[this.objectErrors.size()];
        for (int i = 0; i < this.objectErrors.size(); ++i) {
            ObjectError objectError = (ObjectError)this.objectErrors.get(i);
            this.errorCodes[i] = objectError.getCode();
        }
    }

    private void initErrorMessages() throws NoSuchMessageException {
        if (this.errorMessages == null) {
            this.errorMessages = new String[this.objectErrors.size()];
            for (int i = 0; i < this.objectErrors.size(); ++i) {
                ObjectError objectError = (ObjectError)this.objectErrors.get(i);
                this.errorMessages[i] = this.requestContext.getMessage((MessageSourceResolvable)objectError, this.htmlEscape);
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getExpression() {
        return this.expression;
    }

    public Object getValue() {
        return this.value;
    }

    public Class getValueType() {
        return this.valueType;
    }

    public String getDisplayValue() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.value != null) {
            return this.htmlEscape ? HtmlUtils.htmlEscape((String)this.value.toString()) : this.value.toString();
        }
        return "";
    }

    public boolean isError() {
        return this.errorCodes != null && this.errorCodes.length > 0;
    }

    public String[] getErrorCodes() {
        return this.errorCodes;
    }

    public String getErrorCode() {
        return this.errorCodes.length > 0 ? this.errorCodes[0] : "";
    }

    public String[] getErrorMessages() {
        this.initErrorMessages();
        return this.errorMessages;
    }

    public String getErrorMessage() {
        this.initErrorMessages();
        return this.errorMessages.length > 0 ? this.errorMessages[0] : "";
    }

    public String getErrorMessagesAsString(String string) {
        this.initErrorMessages();
        return StringUtils.arrayToDelimitedString((Object[])this.errorMessages, (String)string);
    }

    public Errors getErrors() {
        return this.errors;
    }

    public PropertyEditor getEditor() {
        return this.editor;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("BindStatus: ");
        stringBuffer.append("expression=[").append(this.expression).append("]; ");
        stringBuffer.append("value=[").append(this.value).append("]");
        if (this.isError()) {
            stringBuffer.append("; errorCodes=" + Arrays.asList(this.errorCodes));
        }
        return stringBuffer.toString();
    }
}

