/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

public class ControllerClassNameHandlerMapping
extends AbstractUrlHandlerMapping
implements HandlerMapping {
    private static final String CONTROLLER_SUFFIX = "Controller";
    private Set excludedPackages = Collections.singleton("org.springframework.web.servlet.mvc");
    private Set excludedClasses = Collections.EMPTY_SET;
    static /* synthetic */ Class class$org$springframework$web$servlet$mvc$Controller;
    static /* synthetic */ Class class$org$springframework$web$servlet$mvc$throwaway$ThrowawayController;
    static /* synthetic */ Class class$org$springframework$web$servlet$mvc$multiaction$MultiActionController;

    public void setExcludedPackages(String[] stringArray) {
        this.excludedPackages = stringArray != null ? new HashSet<String>(Arrays.asList(stringArray)) : Collections.EMPTY_SET;
    }

    public void setExcludedClasses(Class[] classArray) {
        this.excludedClasses = classArray != null ? new HashSet<Class>(Arrays.asList(classArray)) : Collections.EMPTY_SET;
    }

    protected void initApplicationContext() {
        super.initApplicationContext();
        this.detectControllers();
    }

    protected void detectControllers() throws BeansException {
        this.registerControllers(class$org$springframework$web$servlet$mvc$Controller == null ? (class$org$springframework$web$servlet$mvc$Controller = ControllerClassNameHandlerMapping.class$("org.springframework.web.servlet.mvc.Controller")) : class$org$springframework$web$servlet$mvc$Controller);
        this.registerControllers(class$org$springframework$web$servlet$mvc$throwaway$ThrowawayController == null ? (class$org$springframework$web$servlet$mvc$throwaway$ThrowawayController = ControllerClassNameHandlerMapping.class$("org.springframework.web.servlet.mvc.throwaway.ThrowawayController")) : class$org$springframework$web$servlet$mvc$throwaway$ThrowawayController);
    }

    protected void registerControllers(Class clazz) throws BeansException {
        String[] stringArray = this.getApplicationContext().getBeanNamesForType(clazz);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Class clazz2 = this.getApplicationContext().getType(string);
            if (!this.isEligibleForMapping(string, clazz2)) continue;
            this.registerController(string, clazz2);
        }
    }

    protected boolean isEligibleForMapping(String string, Class clazz) {
        if (clazz == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Excluding controller bean '" + string + "' from class name mapping " + "because its bean type could not be determined"));
            }
            return false;
        }
        if (this.excludedClasses.contains(clazz)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Excluding controller bean '" + string + "' from class name mapping " + "because its bean class is explicitly excluded: " + clazz.getName()));
            }
            return false;
        }
        String string2 = clazz.getName();
        Iterator iterator = this.excludedPackages.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string2.startsWith(string3)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Excluding controller bean '" + string + "' from class name mapping " + "because its bean class is defined in an excluded package: " + clazz.getName()));
            }
            return false;
        }
        return true;
    }

    protected void registerController(String string, Class clazz) throws BeansException, IllegalStateException {
        String string2 = this.generatePathMapping(clazz);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering Controller '" + string + "' as handler for URL path [" + string2 + "]"));
        }
        this.registerHandler(string2, (Object)string);
    }

    protected String generatePathMapping(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer("/");
        String string = ClassUtils.getShortName((String)clazz.getName());
        String string2 = string.endsWith(CONTROLLER_SUFFIX) ? string.substring(0, string.indexOf(CONTROLLER_SUFFIX)) : string;
        stringBuffer.append(string2.toLowerCase());
        if ((class$org$springframework$web$servlet$mvc$multiaction$MultiActionController == null ? (class$org$springframework$web$servlet$mvc$multiaction$MultiActionController = ControllerClassNameHandlerMapping.class$("org.springframework.web.servlet.mvc.multiaction.MultiActionController")) : class$org$springframework$web$servlet$mvc$multiaction$MultiActionController).isAssignableFrom(clazz)) {
            stringBuffer.append("/*");
        } else {
            stringBuffer.append("*");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

