/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.multiaction;

import java.util.Iterator;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.mvc.multiaction.AbstractUrlMethodNameResolver;

public class PropertiesMethodNameResolver
extends AbstractUrlMethodNameResolver
implements InitializingBean {
    private Properties mappings;
    private PathMatcher pathMatcher = new AntPathMatcher();

    public void setMappings(Properties properties) {
        this.mappings = properties;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public void afterPropertiesSet() {
        if (this.mappings == null || this.mappings.isEmpty()) {
            throw new IllegalArgumentException("'mappings' property is required");
        }
    }

    protected String getHandlerMethodNameForUrlPath(String string) {
        String string2 = this.mappings.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        Iterator<Object> iterator = this.mappings.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!this.pathMatcher.match(string3, string)) continue;
            return (String)this.mappings.get(string3);
        }
        return null;
    }
}

