/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.multiaction;

import java.util.Properties;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.multiaction.MethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;
import org.springframework.web.util.WebUtils;

public class ParameterMethodNameResolver
implements MethodNameResolver {
    public static final String DEFAULT_PARAM_NAME = "action";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String paramName = "action";
    private String[] methodParamNames;
    private Properties logicalMappings;
    private String defaultMethodName;

    public void setParamName(String string) {
        if (string != null) {
            Assert.hasText((String)string, (String)"'paramName' must not be empty");
        }
        this.paramName = string;
    }

    public void setMethodParamNames(String[] stringArray) {
        this.methodParamNames = stringArray;
    }

    public void setLogicalMappings(Properties properties) {
        this.logicalMappings = properties;
    }

    public void setDefaultMethodName(String string) {
        if (string != null) {
            Assert.hasText((String)string, (String)"'defaultMethodName' must not be empty");
        }
        this.defaultMethodName = string;
    }

    public String getHandlerMethodName(HttpServletRequest httpServletRequest) throws NoSuchRequestHandlingMethodException {
        String string = null;
        if (this.methodParamNames != null) {
            for (int i = 0; i < this.methodParamNames.length; ++i) {
                String string2 = this.methodParamNames[i];
                if (!WebUtils.hasSubmitParameter((ServletRequest)httpServletRequest, (String)string2)) continue;
                string = string2;
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug((Object)("Determined handler method '" + string + "' based on existence of explicit request parameter of same name"));
                break;
            }
        }
        if (string == null && this.paramName != null && (string = httpServletRequest.getParameter(this.paramName)) != null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Determined handler method '" + string + "' based on value of request parameter '" + this.paramName + "'"));
        }
        if (string != null && this.logicalMappings != null) {
            String string3 = string;
            string = this.logicalMappings.getProperty(string, string);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Resolved method name '" + string3 + "' to handler method '" + string + "'"));
            }
        }
        if (string != null && !StringUtils.hasText(string)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Method name '" + string + "' is empty: treating it as no method name found"));
            }
            string = null;
        }
        if (string == null) {
            if (this.defaultMethodName != null) {
                string = this.defaultMethodName;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Falling back to default handler method '" + this.defaultMethodName + "'"));
                }
            } else {
                throw new NoSuchRequestHandlingMethodException(httpServletRequest);
            }
        }
        return string;
    }
}

