/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.multiaction;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.mvc.LastModified;
import org.springframework.web.servlet.mvc.multiaction.InternalPathMethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.MethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;
import org.springframework.web.util.NestedServletException;

public class MultiActionController
extends AbstractController
implements LastModified {
    public static final String LAST_MODIFIED_METHOD_SUFFIX = "LastModified";
    public static final String DEFAULT_COMMAND_NAME = "command";
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private MethodNameResolver methodNameResolver = new InternalPathMethodNameResolver();
    private Validator[] validators;
    private Object delegate;
    private Map handlerMethodMap = new HashMap();
    private Map lastModifiedMethodMap = new HashMap();
    private Map exceptionHandlerMap = new HashMap();
    static /* synthetic */ Class class$org$springframework$web$servlet$ModelAndView;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$javax$servlet$http$HttpSession;

    public MultiActionController() {
        this.delegate = this;
        this.registerHandlerMethods(this.delegate);
    }

    public MultiActionController(Object object) {
        this.setDelegate(object);
    }

    public final void setMethodNameResolver(MethodNameResolver methodNameResolver) {
        this.methodNameResolver = methodNameResolver;
    }

    public final MethodNameResolver getMethodNameResolver() {
        return this.methodNameResolver;
    }

    public final void setValidators(Validator[] validatorArray) {
        this.validators = validatorArray;
    }

    public final Validator[] getValidators() {
        return this.validators;
    }

    public final void setDelegate(Object object) {
        Assert.notNull((Object)object, (String)"Delegate must not be null");
        this.delegate = object;
        this.registerHandlerMethods(this.delegate);
        if (this.handlerMethodMap.isEmpty()) {
            throw new IllegalStateException("No handler methods in class [" + this.delegate.getClass() + "]");
        }
    }

    private void registerHandlerMethods(Object object) {
        Method method;
        int n;
        this.handlerMethodMap.clear();
        this.lastModifiedMethodMap.clear();
        this.exceptionHandlerMap.clear();
        Method[] methodArray = object.getClass().getMethods();
        for (n = 0; n < methodArray.length; ++n) {
            method = methodArray[n];
            if (!this.isHandlerMethod(method)) continue;
            this.registerHandlerMethod(method);
            this.registerLastModifiedMethodIfExists(object, method);
        }
        for (n = 0; n < methodArray.length; ++n) {
            method = methodArray[n];
            if (!this.isExceptionHandlerMethod(method)) continue;
            this.registerExceptionHandlerMethod(method);
        }
    }

    private boolean isHandlerMethod(Method method) {
        Class<?> clazz;
        if ((class$org$springframework$web$servlet$ModelAndView == null ? (class$org$springframework$web$servlet$ModelAndView = MultiActionController.class$("org.springframework.web.servlet.ModelAndView")) : class$org$springframework$web$servlet$ModelAndView).equals(clazz = method.getReturnType()) || (class$java$util$Map == null ? (class$java$util$Map = MultiActionController.class$("java.util.Map")) : class$java$util$Map).equals(clazz) || Void.TYPE.equals(clazz)) {
            Class<?>[] classArray = method.getParameterTypes();
            return classArray.length >= 2 && (class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = MultiActionController.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest).equals(classArray[0]) && (class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = MultiActionController.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse).equals(classArray[1]) && (!"handleRequest".equals(method.getName()) || classArray.length != 2);
        }
        return false;
    }

    private boolean isExceptionHandlerMethod(Method method) {
        return this.isHandlerMethod(method) && method.getParameterTypes().length == 3 && (class$java$lang$Throwable == null ? (class$java$lang$Throwable = MultiActionController.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(method.getParameterTypes()[2]);
    }

    private void registerHandlerMethod(Method method) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found action method [" + method + "]"));
        }
        this.handlerMethodMap.put(method.getName(), method);
    }

    private void registerLastModifiedMethodIfExists(Object object, Method method) {
        try {
            Method method2 = object.getClass().getMethod(method.getName() + LAST_MODIFIED_METHOD_SUFFIX, class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = MultiActionController.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest);
            this.lastModifiedMethodMap.put(method.getName(), method2);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found last modified method for action method [" + method + "]"));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private void registerExceptionHandlerMethod(Method method) {
        this.exceptionHandlerMap.put(method.getParameterTypes()[2], method);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found exception handler method [" + method + "]"));
        }
    }

    public long getLastModified(HttpServletRequest httpServletRequest) {
        try {
            String string = this.methodNameResolver.getHandlerMethodName(httpServletRequest);
            Method method = (Method)this.lastModifiedMethodMap.get(string);
            if (method != null) {
                try {
                    Long l = (Long)method.invoke(this.delegate, httpServletRequest);
                    return l;
                }
                catch (Exception exception) {
                    this.logger.error((Object)"Failed to invoke last-modified method", (Throwable)exception);
                }
            }
        }
        catch (NoSuchRequestHandlingMethodException noSuchRequestHandlingMethodException) {
            // empty catch block
        }
        return -1L;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            String string = this.methodNameResolver.getHandlerMethodName(httpServletRequest);
            return this.invokeNamedMethod(string, httpServletRequest, httpServletResponse);
        }
        catch (NoSuchRequestHandlingMethodException noSuchRequestHandlingMethodException) {
            return this.handleNoSuchRequestHandlingMethod(noSuchRequestHandlingMethodException, httpServletRequest, httpServletResponse);
        }
    }

    protected ModelAndView handleNoSuchRequestHandlingMethod(NoSuchRequestHandlingMethodException noSuchRequestHandlingMethodException, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        pageNotFoundLogger.warn((Object)noSuchRequestHandlingMethodException.getMessage());
        httpServletResponse.sendError(404);
        return null;
    }

    protected final ModelAndView invokeNamedMethod(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Method method = (Method)this.handlerMethodMap.get(string);
        if (method == null) {
            throw new NoSuchRequestHandlingMethodException(string, this.getClass());
        }
        try {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>(4);
            arrayList.add(httpServletRequest);
            arrayList.add(httpServletResponse);
            if (method.getParameterTypes().length >= 3 && method.getParameterTypes()[2].equals(class$javax$servlet$http$HttpSession == null ? (class$javax$servlet$http$HttpSession = MultiActionController.class$("javax.servlet.http.HttpSession")) : class$javax$servlet$http$HttpSession)) {
                object = httpServletRequest.getSession(false);
                if (object == null) {
                    throw new HttpSessionRequiredException("Pre-existing session required for handler method '" + string + "'");
                }
                arrayList.add(object);
            }
            if (method.getParameterTypes().length >= 3 && !method.getParameterTypes()[method.getParameterTypes().length - 1].equals(class$javax$servlet$http$HttpSession == null ? (class$javax$servlet$http$HttpSession = MultiActionController.class$("javax.servlet.http.HttpSession")) : class$javax$servlet$http$HttpSession)) {
                object = this.newCommandObject(method.getParameterTypes()[method.getParameterTypes().length - 1]);
                arrayList.add(object);
                this.bind(httpServletRequest, object);
            }
            object = method.invoke(this.delegate, arrayList.toArray(new Object[arrayList.size()]));
            return this.massageReturnValueIfNecessary(object);
        }
        catch (InvocationTargetException invocationTargetException) {
            return this.handleException(httpServletRequest, httpServletResponse, invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            return this.handleException(httpServletRequest, httpServletResponse, exception);
        }
    }

    private ModelAndView massageReturnValueIfNecessary(Object object) {
        if (object instanceof ModelAndView) {
            return (ModelAndView)object;
        }
        if (object instanceof Map) {
            return new ModelAndView().addAllObjects((Map)object);
        }
        return null;
    }

    protected Object newCommandObject(Class clazz) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Must create new command of class [" + clazz.getName() + "]"));
        }
        return BeanUtils.instantiateClass((Class)clazz);
    }

    protected void bind(HttpServletRequest httpServletRequest, Object object) throws Exception {
        this.logger.debug((Object)"Binding request parameters onto MultiActionController command");
        ServletRequestDataBinder servletRequestDataBinder = this.createBinder(httpServletRequest, object);
        servletRequestDataBinder.bind((ServletRequest)httpServletRequest);
        if (this.validators != null) {
            for (int i = 0; i < this.validators.length; ++i) {
                if (!this.validators[i].supports(object.getClass())) continue;
                ValidationUtils.invokeValidator((Validator)this.validators[i], (Object)object, (Errors)servletRequestDataBinder.getBindingResult());
            }
        }
        servletRequestDataBinder.closeNoCatch();
    }

    protected ServletRequestDataBinder createBinder(HttpServletRequest httpServletRequest, Object object) throws Exception {
        ServletRequestDataBinder servletRequestDataBinder = new ServletRequestDataBinder(object, this.getCommandName(object));
        this.initBinder(httpServletRequest, servletRequestDataBinder);
        return servletRequestDataBinder;
    }

    protected String getCommandName(Object object) {
        return DEFAULT_COMMAND_NAME;
    }

    protected void initBinder(HttpServletRequest httpServletRequest, ServletRequestDataBinder servletRequestDataBinder) throws Exception {
        this.initBinder((ServletRequest)httpServletRequest, servletRequestDataBinder);
    }

    protected void initBinder(ServletRequest servletRequest, ServletRequestDataBinder servletRequestDataBinder) throws Exception {
    }

    protected Method getExceptionHandler(Throwable throwable) {
        Class<?> clazz = throwable.getClass();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Trying to find handler for exception class [" + clazz.getName() + "]"));
        }
        Method method = (Method)this.exceptionHandlerMap.get(clazz);
        while (method == null && !clazz.equals(class$java$lang$Throwable == null ? MultiActionController.class$("java.lang.Throwable") : class$java$lang$Throwable)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Trying to find handler for exception superclass [" + clazz.getName() + "]"));
            }
            clazz = clazz.getSuperclass();
            method = (Method)this.exceptionHandlerMap.get(clazz);
        }
        return method;
    }

    private ModelAndView handleException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Throwable throwable) throws Exception {
        Method method = this.getExceptionHandler(throwable);
        if (method != null) {
            return this.invokeExceptionHandler(method, httpServletRequest, httpServletResponse, throwable);
        }
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new NestedServletException("Unknown Throwable type encountered", throwable);
    }

    private ModelAndView invokeExceptionHandler(Method method, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Throwable throwable) throws Exception {
        if (method == null) {
            throw new NestedServletException("No handler for exception", throwable);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking exception handler [" + method + "] for exception [" + throwable + "]"));
        }
        try {
            Object object = method.invoke(this.delegate, httpServletRequest, httpServletResponse, throwable);
            return this.massageReturnValueIfNecessary(object);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable2 = invocationTargetException.getTargetException();
            if (throwable2 instanceof Exception) {
                throw (Exception)throwable2;
            }
            if (throwable2 instanceof Error) {
                throw (Error)throwable2;
            }
            throw new NestedServletException("Unknown Throwable type encountered", throwable2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

