/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.multiaction;

import java.util.Map;
import org.springframework.core.CollectionFactory;
import org.springframework.web.servlet.mvc.multiaction.AbstractUrlMethodNameResolver;
import org.springframework.web.util.WebUtils;

public class InternalPathMethodNameResolver
extends AbstractUrlMethodNameResolver {
    private String prefix = "";
    private String suffix = "";
    private final Map methodNameCache = CollectionFactory.createConcurrentMapIfPossible((int)16);

    public void setPrefix(String string) {
        this.prefix = string != null ? string : "";
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public void setSuffix(String string) {
        this.suffix = string != null ? string : "";
    }

    protected String getSuffix() {
        return this.suffix;
    }

    protected String getHandlerMethodNameForUrlPath(String string) {
        String string2 = (String)this.methodNameCache.get(string);
        if (string2 == null) {
            string2 = this.extractHandlerMethodNameFromUrlPath(string);
            string2 = this.postProcessHandlerMethodName(string2);
            this.methodNameCache.put(string, string2);
        }
        return string2;
    }

    protected String extractHandlerMethodNameFromUrlPath(String string) {
        return WebUtils.extractFilenameFromUrlPath((String)string);
    }

    protected String postProcessHandlerMethodName(String string) {
        return this.getPrefix() + string + this.getSuffix();
    }
}

