/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.multiaction;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.mvc.multiaction.MethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;
import org.springframework.web.util.UrlPathHelper;

public abstract class AbstractUrlMethodNameResolver
implements MethodNameResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    public void setAlwaysUseFullPath(boolean bl) {
        this.urlPathHelper.setAlwaysUseFullPath(bl);
    }

    public void setUrlDecode(boolean bl) {
        this.urlPathHelper.setUrlDecode(bl);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public final String getHandlerMethodName(HttpServletRequest httpServletRequest) throws NoSuchRequestHandlingMethodException {
        String string = this.urlPathHelper.getLookupPathForRequest(httpServletRequest);
        String string2 = this.getHandlerMethodNameForUrlPath(string);
        if (string2 == null) {
            throw new NoSuchRequestHandlingMethodException(httpServletRequest);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Returning handler method name '" + string2 + "' for lookup path: " + string));
        }
        return string2;
    }

    protected abstract String getHandlerMethodNameForUrlPath(String var1);
}

