/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.LastModified;
import org.springframework.web.servlet.support.WebContentGenerator;
import org.springframework.web.util.UrlPathHelper;

public class WebContentInterceptor
extends WebContentGenerator
implements HandlerInterceptor {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private Map cacheMappings = new HashMap();
    private PathMatcher pathMatcher = new AntPathMatcher();

    public void setAlwaysUseFullPath(boolean bl) {
        this.urlPathHelper.setAlwaysUseFullPath(bl);
    }

    public void setUrlDecode(boolean bl) {
        this.urlPathHelper.setUrlDecode(bl);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public void setCacheMappings(Properties properties) {
        this.cacheMappings.clear();
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.cacheMappings.put(string, Integer.valueOf(properties.getProperty(string)));
        }
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws ServletException {
        Integer n;
        String string = this.urlPathHelper.getLookupPathForRequest(httpServletRequest);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up cache seconds for [" + string + "]"));
        }
        if ((n = this.lookupCacheSeconds(string)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Applying " + n + " cache seconds to [" + string + "]"));
            }
            this.checkAndPrepare(httpServletRequest, httpServletResponse, n, object instanceof LastModified);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Applying default cache seconds to [" + string + "]"));
            }
            this.checkAndPrepare(httpServletRequest, httpServletResponse, object instanceof LastModified);
        }
        return true;
    }

    protected Integer lookupCacheSeconds(String string) {
        Integer n = (Integer)this.cacheMappings.get(string);
        if (n == null) {
            Iterator iterator = this.cacheMappings.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!this.pathMatcher.match(string2, string)) continue;
                n = (Integer)this.cacheMappings.get(string2);
            }
        }
        return n;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, Exception exception) throws Exception {
    }
}

