/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.CollectionFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.AbstractUrlViewController;

public class UrlFilenameViewController
extends AbstractUrlViewController {
    private String prefix = "";
    private String suffix = "";
    private final Map viewNameCache = CollectionFactory.createConcurrentMapIfPossible((int)16);

    public void setPrefix(String string) {
        this.prefix = string != null ? string : "";
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public void setSuffix(String string) {
        this.suffix = string != null ? string : "";
    }

    protected String getSuffix() {
        return this.suffix;
    }

    protected String getViewNameForRequest(HttpServletRequest httpServletRequest) {
        String string = this.extractOperableUrl(httpServletRequest);
        return this.getViewNameForUrlPath(string);
    }

    protected String extractOperableUrl(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (!StringUtils.hasText((String)string)) {
            string = this.getUrlPathHelper().getLookupPathForRequest(httpServletRequest);
        }
        return string;
    }

    protected String getViewNameForUrlPath(String string) {
        String string2 = (String)this.viewNameCache.get(string);
        if (string2 == null) {
            string2 = this.extractViewNameFromUrlPath(string);
            string2 = this.postProcessViewName(string2);
            this.viewNameCache.put(string, string2);
        }
        return string2;
    }

    protected String extractViewNameFromUrlPath(String string) {
        int n = string.charAt(0) == '/' ? 1 : 0;
        int n2 = string.lastIndexOf(".");
        int n3 = n2 < 0 ? string.length() : n2;
        return string.substring(n, n3);
    }

    protected String postProcessViewName(String string) {
        return this.getPrefix() + string + this.getSuffix();
    }
}

